/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.other;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import io.github.simonalexs.base.StaticVariables;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class PrintUtil {
    public static void println(Object ... objs) {
        PrintUtil.doPrint(objs, System.out::println);
    }

    public static void print(Object ... objs) {
        PrintUtil.doPrint(objs, System.out::print);
    }

    public static void flush() {
        System.out.flush();
    }

    private static void doPrint(Object[] objs, Consumer<String> printer) {
        String str;
        if (objs == null) {
            str = PrintUtil.toStr(false, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < objs.length; ++i) {
                if (i != 0) {
                    builder.append(" ");
                }
                builder.append(PrintUtil.toStr(Config.PRETTY_PRINT, objs[i]));
            }
            str = builder.toString();
        }
        String info = PrintUtil.wrap(str);
        printer.accept(info);
    }

    public static void printResultSet(ResultSet resultSet) {
        PrintUtil.printResultSet(resultSet, Integer.MAX_VALUE);
    }

    public static void printResultSet(ResultSet resultSet, int printDataNum) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String> colTypeNameList = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                String typeName = StaticVariables.SQL_TYPES.get(metaData.getColumnType(i));
                colTypeNameList.add(typeName);
            }
            ArrayList<String> colNameList = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                colNameList.add(metaData.getColumnLabel(i));
            }
            ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
            int realPrintDataNum = Math.max(printDataNum, 0);
            for (int readiedNums = 0; readiedNums < realPrintDataNum && resultSet.next(); ++readiedNums) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    row.add(resultSet.getObject(i));
                }
                dataList.add(row);
            }
            String resultSetStr = JDBCUtil.generateResultSetStr(colTypeNameList, dataList, colNameList);
            String wrapInfo = PrintUtil.wrap("");
            if (!wrapInfo.isEmpty()) {
                System.out.println(wrapInfo);
            }
            System.out.println(resultSetStr);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printList(List<?> ... objList) {
        PrintUtil.printList("", objList);
    }

    public static void printList(String lineSeparatorBetweenParam, List<?> ... objList) {
        PrintUtil.printList("", lineSeparatorBetweenParam, "", objList);
    }

    public static void printList(String header, String lineSeparatorBetweenParam, String footer, List<?> ... objList) {
        String wrapInfo;
        if (objList == null || objList.length == 0) {
            PrintUtil.println(new Object[0]);
            return;
        }
        Pair<List<Integer>, String> columnWidthConfig = PrintUtil.getColumnWidthConfig(objList);
        List widthConfig = (List)columnWidthConfig.getLeft();
        int wholeWidth = ((String)columnWidthConfig.getRight()).length();
        StringBuilder builder = new StringBuilder();
        if (header != null && !header.isEmpty()) {
            builder.append(JDBCUtil.repeat(header, wholeWidth)).append("\n");
        }
        for (int i = 0; i < objList.length; ++i) {
            List<?> list = objList[i];
            if (List.class.isAssignableFrom(list.get(0).getClass())) {
                for (Object rowObj : list) {
                    String rowStr = PrintUtil.generateRowStr((List)rowObj, widthConfig);
                    builder.append(rowStr).append("\n");
                }
            } else {
                String rowStr = PrintUtil.generateRowStr(list, widthConfig);
                builder.append(rowStr).append("\n");
            }
            if (i >= objList.length - 1 || lineSeparatorBetweenParam == null || lineSeparatorBetweenParam.isEmpty()) continue;
            builder.append(JDBCUtil.repeat(lineSeparatorBetweenParam, wholeWidth)).append("\n");
        }
        if (footer != null && !footer.isEmpty()) {
            builder.append(JDBCUtil.repeat(footer, wholeWidth)).append("\n");
        }
        if (!(wrapInfo = PrintUtil.wrap("")).isEmpty()) {
            System.out.println(wrapInfo);
        }
        System.out.println(builder);
    }

    public static Pair<List<Integer>, String> getColumnWidthConfig(List<?> ... objList) {
        int realColumnCount = JDBCUtil.getRealColumnCount(objList);
        List<Integer> columnWidthConfig = IntStream.range(0, realColumnCount).boxed().map(t -> 0).collect(Collectors.toList());
        for (List<?> list : objList) {
            if (List.class.isAssignableFrom(list.get(0).getClass())) {
                for (Object rowObj : list) {
                    JDBCUtil.scanRowColumnWidth((List)rowObj, columnWidthConfig);
                }
                continue;
            }
            JDBCUtil.scanRowColumnWidth(list, columnWidthConfig);
        }
        int wholeWidth = 0;
        for (Integer width : columnWidthConfig) {
            wholeWidth += width + 4;
        }
        String seperatorStr = JDBCUtil.repeat("-", wholeWidth -= 4);
        return Pair.of(columnWidthConfig, (Object)seperatorStr);
    }

    public static String generateRowStr(List<?> row, List<Integer> columnWidthConfig) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            String formatted = JDBCUtil.formatObj(row.get(i), columnWidthConfig.get(i));
            stringBuilder.append(formatted);
            if (i == row.size() - 1) continue;
            stringBuilder.append(JDBCUtil.COLUMN_INTERVAL_STR);
        }
        return stringBuilder.toString();
    }

    public static String wrap(String msg) {
        if (!Config.PRINT_TIME_INFO) {
            return msg;
        }
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        Thread currentThread = Thread.currentThread();
        StackTraceElement element = currentThread.getStackTrace()[2];
        String fullClassName = element.getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        return time + " \u3010" + currentThread.getName() + "\u3011 " + simpleClassName + "." + element.getMethodName() + "[" + element.getLineNumber() + "] " + msg;
    }

    private static String toStr(Object value) {
        return PrintUtil.toStr(false, value);
    }

    private static String toStr(boolean prettyFormat, Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return value.toString();
        }
        ArrayList<JSONWriter.Feature> featureList = new ArrayList<JSONWriter.Feature>(Arrays.asList(JSONWriter.Feature.FieldBased, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.UnquoteFieldName));
        if (prettyFormat) {
            featureList.add(JSONWriter.Feature.PrettyFormat);
        }
        JSONWriter.Feature[] features = new JSONWriter.Feature[featureList.size()];
        for (int i = 0; i < featureList.size(); ++i) {
            features[i] = (JSONWriter.Feature)featureList.get(i);
        }
        return JSON.toJSONString((Object)value, (JSONWriter.Feature[])features);
    }

    protected static class JDBCUtil {
        protected static final int COLUMN_INTERVAL_WIDTH = 4;
        protected static final String COLUMN_INTERVAL_STR = JDBCUtil.repeat(" ", 4);
        protected static final String WHITE_STR = " ";

        protected JDBCUtil() {
        }

        static String generateResultSetStr(List<String> matadataList, List<List<Object>> rows, List<String> colNameList) {
            StringBuilder stringBuilder = new StringBuilder();
            Pair<List<Integer>, String> columnWidthPair = PrintUtil.getColumnWidthConfig(matadataList, rows, colNameList);
            String lineSeparator = (String)columnWidthPair.getRight() + "\n";
            stringBuilder.append(lineSeparator);
            List columnWidthConfig = (List)columnWidthPair.getLeft();
            if (colNameList != null) {
                stringBuilder.append(PrintUtil.generateRowStr(colNameList, columnWidthConfig)).append("\n");
            }
            stringBuilder.append(PrintUtil.generateRowStr(matadataList, columnWidthConfig)).append("\n");
            stringBuilder.append(lineSeparator);
            for (List<Object> row : rows) {
                stringBuilder.append(PrintUtil.generateRowStr(row, columnWidthConfig)).append("\n");
            }
            stringBuilder.append(lineSeparator);
            return stringBuilder.toString();
        }

        public static String formatRowData(List<?> rowData) {
            int maxWidth = 0;
            for (Object rowDatum : rowData) {
                int width = JDBCUtil.getWidth(rowDatum);
                maxWidth = Math.max(maxWidth, width);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < rowData.size(); ++i) {
                String formatted = JDBCUtil.formatObj(rowData.get(i), maxWidth);
                if (i != 0) {
                    builder.append("\t");
                }
                builder.append(formatted);
            }
            return builder.toString();
        }

        static String formatObj(Object value, int widthConfig) {
            int width = JDBCUtil.getWidth(value);
            return JDBCUtil.repeat(WHITE_STR, widthConfig - width) + PrintUtil.toStr(value);
        }

        protected static void scanRowColumnWidth(List<?> row, List<Integer> columnWidthConfig) {
            for (int i = 0; i < row.size(); ++i) {
                Object value = row.get(i);
                int thisWidth = JDBCUtil.getWidth(value);
                Integer preWidth = columnWidthConfig.get(i);
                int max = Math.max(thisWidth, preWidth);
                columnWidthConfig.set(i, max);
            }
        }

        protected static int getRealColumnCount(List<?>[] objList) {
            int realColumnCount = 0;
            for (List<?> list : objList) {
                int columnCount;
                if (!list.isEmpty() && List.class.isAssignableFrom(list.get(0).getClass())) {
                    columnCount = ((List)list.get(0)).size();
                    if (realColumnCount != 0 && realColumnCount != columnCount) {
                        throw new RuntimeException("\u53c2\u6570\u4e2d\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5404\u53c2\u6570\uff08\u5355list\u4e0e\u5d4c\u5957list\uff09\u7684\u5217\u6570\u662f\u5426\u4e00\u81f4");
                    }
                    realColumnCount = columnCount;
                    continue;
                }
                columnCount = list.size();
                if (realColumnCount != 0 && realColumnCount != columnCount) {
                    throw new RuntimeException("\u53c2\u6570\u4e2d\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5404\u53c2\u6570\uff08\u5355list\u4e0e\u5d4c\u5957list\uff09\u7684\u5217\u6570\u662f\u5426\u4e00\u81f4");
                }
                realColumnCount = columnCount;
            }
            return realColumnCount;
        }

        protected static int getWidth(Object value) {
            return JDBCUtil.getWordCount(PrintUtil.toStr(value));
        }

        protected static String repeat(String str, int times) {
            return String.join((CharSequence)"", Collections.nCopies(times, str));
        }

        protected static int getWordCount(String s) {
            int length = 0;
            for (int i = 0; i < s.length(); ++i) {
                int ascii = Character.codePointAt(s, i);
                if (ascii >= 0 && ascii <= 255) {
                    ++length;
                    continue;
                }
                length += 2;
            }
            return length;
        }
    }

    public static class Config {
        private static boolean PRINT_TIME_INFO = true;
        private static boolean PRETTY_PRINT = false;

        public static boolean isPrintTimeInfo() {
            return PRINT_TIME_INFO;
        }

        public static void setPrintTimeInfo(boolean printTimeInfo) {
            PRINT_TIME_INFO = printTimeInfo;
        }

        public static boolean isPrettyPrint() {
            return PRETTY_PRINT;
        }

        public static void setPrettyPrint(boolean prettyPrint) {
            PRETTY_PRINT = prettyPrint;
        }
    }
}

