/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.base.scanner;

import io.github.simonalexs.base.scanner.IScan;
import io.github.simonalexs.base.scanner.JarScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public class ScanExecutor
implements IScan {
    private static final List<IScan> SCANNER_LIST = new ArrayList<IScan>();

    @Override
    public List<Class<?>> search(String packageName, Predicate<Class<?>> predicate) {
        HashSet set = new HashSet();
        for (IScan iScan : SCANNER_LIST) {
            List<Class<?>> search = iScan.search(packageName, predicate);
            set.addAll(search);
        }
        return new ArrayList(set);
    }

    public static ScanExecutor getInstance() {
        return new ScanExecutor();
    }

    static {
        JarScanner jarScanner = new JarScanner();
        List<Class<?>> jarSearch = jarScanner.search(ScanExecutor.class.getPackage().getName(), clazz -> IScan.class.isAssignableFrom((Class<?>)clazz) && clazz != ScanExecutor.class && clazz != IScan.class);
        try {
            for (Class<?> aClass : jarSearch) {
                IScan iScan = (IScan)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                SCANNER_LIST.add(iScan);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

