/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools;

import io.github.simonalexs.annotation.Func;
import io.github.simonalexs.annotation.Param;
import io.github.simonalexs.tools.ScheduleUtil;
import io.github.simonalexs.tools.other.PrintUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class WinUtil {
    public static void copy(String content) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(content);
        clip.setContents(tText, null);
    }

    public static void checkAndAutoStartAppPeriodically(String pathOfApp) throws IOException {
        WinUtil.checkAndAutoStartAppPeriodically(pathOfApp, 2, 3);
    }

    public static void checkAndAutoStartAppPeriodically(String pathOfApp, int waitingSecondForStart, int checkPeriodSecond) throws IOException {
        WinUtil.checkAndAutoStartAppPeriodically(pathOfApp, waitingSecondForStart, checkPeriodSecond, Integer.MAX_VALUE);
    }

    @Func
    public static void checkAndAutoStartAppPeriodically(String pathOfApp, @Param(value="2") int waitingSecondForStart, @Param(value="3") int checkPeriodSecond, @Param(value="2147483647") int wholeRunSecondsOfTool) {
        Runnable runnable = () -> {
            try {
                if (!WinUtil.findProcess(pathOfApp) && !WinUtil.startApp(pathOfApp, waitingSecondForStart)) {
                    PrintUtil.println("\u542f\u52a8\u5931\u8d25");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        ScheduleUtil.runPeriodically(runnable, checkPeriodSecond * 1000, wholeRunSecondsOfTool * 1000);
    }

    public static boolean startApp(String pathOfApp, int waitingSecondForStart) throws Exception {
        Runtime.getRuntime().exec("cmd /c " + WinUtil.dealPath(pathOfApp));
        Thread.sleep((long)waitingSecondForStart * 1000L);
        boolean process = WinUtil.findProcess(pathOfApp);
        if (process) {
            PrintUtil.println("\u542f\u52a8\u6267\u884c\u5b8c\u6210");
        } else {
            PrintUtil.println("\u542f\u52a8\u5931\u8d25");
        }
        return process;
    }

    private static String dealPath(String filePath) {
        return "\"" + filePath + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findProcess(String processNameOrPathOfApp) throws IOException {
        if (processNameOrPathOfApp == null || processNameOrPathOfApp.isEmpty()) {
            throw new IOException("process name must not be null or empty");
        }
        File file = new File(processNameOrPathOfApp);
        String realProcessName = file.isFile() ? file.getName() : processNameOrPathOfApp;
        try (BufferedReader bufferedReader = null;){
            String command = "tasklist -fi \"imagename eq " + realProcessName + '\"';
            Process proc = Runtime.getRuntime().exec(command);
            bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), "GBK"));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.contains(realProcessName)) continue;
                PrintUtil.println("\u6210\u529f\u627e\u5230\u8fdb\u7a0b");
                boolean bl = true;
                return bl;
            }
            PrintUtil.println("\u672a\u627e\u5230\u8fdb\u7a0b");
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean killProcess(String filePath) {
        BufferedReader brStd = null;
        BufferedReader brErr = null;
        try {
            if (filePath == null) return true;
            Process pro = Runtime.getRuntime().exec("c:\\windows\\system32\\taskkill /F /im " + WinUtil.dealPath(filePath));
            brStd = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            brErr = new BufferedReader(new InputStreamReader(pro.getErrorStream()));
            long time = System.currentTimeMillis();
            do {
                if (brStd.ready()) {
                    return true;
                }
                if (!brErr.ready()) continue;
                return true;
            } while (System.currentTimeMillis() - time <= 3000L);
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        finally {
            try {
                if (brErr != null) {
                    brErr.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("\u91ca\u653e\u8d44\u6e90\u5931\u8d25");
            }
            finally {
                try {
                    if (brStd != null) {
                        brStd.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("\u91ca\u653e\u8d44\u6e90\u5931\u8d25");
                }
            }
        }
    }
}

