/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.base.common;

import io.github.simonalexs.tools.other.PrintUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConsolePrintTable {
    private String tableSeparator = "~";
    private String titleSeparator = "=";
    private String rowSeparator = "-";
    private String colSeparator = "    ";
    private int rowLength = 0;
    private String tableTitle = "";
    private List<String> colTitles = new ArrayList<String>();
    private List<List<?>> datas = new ArrayList();

    public static ConsolePrintTable getInstance() {
        return new ConsolePrintTable("");
    }

    public static ConsolePrintTable getInstance(String tableTitle) {
        return new ConsolePrintTable(tableTitle);
    }

    private ConsolePrintTable(String tableTitle) {
        this.tableTitle = tableTitle;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String prettyPrint() {
        Pair<List<Integer>, String> columnWidthConfigPair = PrintUtil.getColumnWidthConfig(this.colTitles, this.datas);
        int rowMaxWidth = ((String)columnWidthConfigPair.getRight()).length();
        StringBuilder result = new StringBuilder();
        String tableTitleRowStr = StringUtils.repeat((String)this.tableSeparator, (int)(rowMaxWidth / 3)) + this.tableTitle + StringUtils.repeat((String)this.tableSeparator, (int)(rowMaxWidth - rowMaxWidth / 3 - this.tableTitle.length()));
        result.append(tableTitleRowStr);
        result.append("\n");
        String colTitleStr = PrintUtil.generateRowStr(this.colTitles, (List)columnWidthConfigPair.getLeft());
        result.append(colTitleStr);
        result.append("\n");
        result.append(StringUtils.repeat((String)this.titleSeparator, (int)rowMaxWidth));
        result.append("\n");
        for (List<?> data : this.datas) {
            String rowStr = PrintUtil.generateRowStr(data, (List)columnWidthConfigPair.getLeft());
            result.append(rowStr);
            result.append("\n");
        }
        return result.toString();
    }

    public static class Builder {
        private final ConsolePrintTable consolePrintTable;

        public Builder(ConsolePrintTable consolePrintTable) {
            this.consolePrintTable = consolePrintTable;
        }

        public Builder addTitle(String title) {
            this.consolePrintTable.colTitles.add(title);
            return this;
        }

        public Builder addTitle(List<String> title) {
            this.consolePrintTable.colTitles.addAll(title);
            return this;
        }

        public Builder addRowData(List<Object> rowData) {
            this.consolePrintTable.datas.add(rowData);
            return this;
        }

        public ConsolePrintTable build() {
            return this.consolePrintTable;
        }
    }
}

