/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.base.scanner;

import io.github.simonalexs.base.scanner.IScan;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class FileScanner
implements IScan {
    public String defaultClassPath = FileScanner.class.getResource("/").getPath();

    @Override
    public List<Class<?>> search(String packageName, Predicate<Class<?>> predicate) {
        String classpath = this.defaultClassPath;
        String basePackPath = packageName.replace(".", File.separator);
        String searchPath = classpath + basePackPath;
        return new ClassSearcher().doPath(new File(searchPath), packageName, predicate, true);
    }

    private static class ClassSearcher {
        private final Set<Class<?>> classPaths = new HashSet();

        private ClassSearcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private List<Class<?>> doPath(File file, String packageName, Predicate<Class<?>> predicate, boolean flag) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (!flag) {
                    packageName = packageName + "." + file.getName();
                }
                assert (files != null);
                for (File f1 : files) {
                    this.doPath(f1, packageName, predicate, false);
                }
                return new ArrayList(this.classPaths);
            } else {
                if (!file.getName().endsWith(".class")) return new ArrayList(this.classPaths);
                try {
                    Class<?> clazz = Class.forName(packageName + "." + file.getName().substring(0, file.getName().lastIndexOf(".")));
                    if (predicate != null && !predicate.test(clazz)) return new ArrayList(this.classPaths);
                    this.classPaths.add(clazz);
                    return new ArrayList(this.classPaths);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return new ArrayList(this.classPaths);
        }
    }
}

