/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.config;

import io.github.simonalexs.enums.SAPropertyEnum;
import io.github.simonalexs.tools.FileUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class ToolConfig {
    private static final Yaml yaml = new Yaml();
    private static final LinkedHashMap<String, String> USER_CONFIG_MAP = new LinkedHashMap();
    private static final String TOOL_PROPERTY_FILE_NAME = "/tool.properties";
    public static final String PROPERTY_FILE_NAME;
    public static final String PROPERTY_FILE_TEMPLATE_CONTENT;

    public static <T> T getParam(SAPropertyEnum keyEnum, Class<T> clazz) {
        return ToolConfig.getParam(keyEnum.getName(), clazz);
    }

    public static <T> T getParamAndCheck(SAPropertyEnum keyEnum, Class<T> clazz) {
        return ToolConfig.getParamAndCheck(keyEnum.getName(), clazz);
    }

    public static String getParamErrorInfo(SAPropertyEnum key) {
        return ToolConfig.getParamErrorInfo(key.getName());
    }

    public static Set<String> getUIdSetByStr(String sendUIdsStr) {
        if (StringUtils.isBlank((CharSequence)sendUIdsStr)) {
            return new HashSet<String>();
        }
        List<String> uidsList = Arrays.asList(StringUtils.split((String)sendUIdsStr, (String)","));
        return uidsList.stream().map(t -> t == null ? null : t.toString().trim()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    private static <T> T getParam(String key, Class<T> clazz) {
        Optional<String> keyOptional = USER_CONFIG_MAP.keySet().stream().filter(t -> t.equalsIgnoreCase(key)).findFirst();
        if (!keyOptional.isPresent()) {
            return null;
        }
        String valueStr = USER_CONFIG_MAP.get(keyOptional.get());
        if (valueStr == null || StringUtils.isBlank((CharSequence)valueStr)) {
            return null;
        }
        return ToolConfig.parse(valueStr, clazz);
    }

    private static <T> T getParamAndCheck(String key, Class<T> clazz) {
        T value = ToolConfig.getParam(key, clazz);
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            throw new RuntimeException(ToolConfig.getParamErrorInfo(key));
        }
        return value;
    }

    private static <T> T parse(String str, Class<T> clazz) {
        try {
            return (T)yaml.loadAs(str, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6" + PROPERTY_FILE_NAME + "\u4e2d\u7684\u5185\u5bb9[" + str + "] " + e.getMessage());
        }
    }

    private static String getParamErrorInfo(String key) {
        return "Param [" + key + "] doesn't exist or is empty, please check the file '" + PROPERTY_FILE_NAME + "', which is the same path with the jar file or in resources.The template content of the file is:" + System.lineSeparator() + PROPERTY_FILE_TEMPLATE_CONTENT;
    }

    static {
        String separator = "/";
        try {
            String userConfigStr;
            Properties properties = new Properties();
            InputStream inputStream = ToolConfig.class.getResourceAsStream(TOOL_PROPERTY_FILE_NAME);
            properties.load(inputStream);
            String userConfigFileTemplateName = properties.get("userConfigTemplateFileName").toString();
            PROPERTY_FILE_TEMPLATE_CONTENT = FileUtil.getContentInResourceOrSamePath(separator + userConfigFileTemplateName);
            PROPERTY_FILE_NAME = properties.get("userConfigFileName").toString();
            try {
                userConfigStr = FileUtil.getContentInResourceOrSamePath(separator + PROPERTY_FILE_NAME);
            }
            catch (Exception e) {
                userConfigStr = "";
            }
            try {
                LinkedHashMap map = ToolConfig.parse(userConfigStr, LinkedHashMap.class);
                map.forEach((k, v) -> USER_CONFIG_MAP.put(k.toString(), v == null ? null : v.toString()));
            }
            catch (Exception e) {
                throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6" + PROPERTY_FILE_NAME + "\u4e2d\u7684\u5185\u5bb9 " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

