/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools;

import io.github.simonalexs.annotation.Func;
import io.github.simonalexs.annotation.Param;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

public class FileUtil {
    @Func
    public static String getContentInResourceOrSamePath(@Param(tip="path of file starting with '/'") String path) throws Exception {
        path = path.replaceAll("\r|\n|\r\n", "");
        try {
            return FileUtil.getContentInResource(path);
        }
        catch (RuntimeException e) {
            try {
                return FileUtil.getContentInSamePath(path);
            }
            catch (RuntimeException e2) {
                throw new Exception("\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e2.getMessage());
            }
        }
    }

    public static String getContentInResource(String path) throws Exception {
        InputStream is = FileUtil.class.getResourceAsStream(path);
        if (is == null) {
            throw new SQLException("\u672a\u627e\u5230\u6587\u4ef6\uff1a" + path);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        return FileUtil.doGetBufferString(in);
    }

    private static String getContentInSamePath(String path) throws Exception {
        String base = FileUtil.getJarPath();
        String decodeBase = null;
        try {
            decodeBase = URLDecoder.decode(base, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("URL\u89e3\u7801\u5931\u8d25\u3010" + base + "\u3011\uff1a" + e.getMessage());
        }
        File file = new File(decodeBase, path);
        if (!file.exists()) {
            throw new FileNotFoundException("\u672a\u627e\u5230\u6587\u4ef6\uff1a\u3010" + decodeBase + path + "\u3011");
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            return FileUtil.doGetBufferString(br);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("\u672a\u627e\u5230\u6587\u4ef6\uff1a\u3010" + path + "\u3011");
        }
    }

    private static String doGetBufferString(BufferedReader in) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String line = "";
        while ((line = in.readLine()) != null) {
            if (buffer.length() != 0) {
                buffer.append(System.lineSeparator());
            }
            buffer.append(line);
        }
        return buffer.toString();
    }

    public static void writeContentInSamePath(String path, String content) throws Exception {
        FileUtil.writeContentInSamePath(path, content, false);
    }

    public static void writeContentInSamePath(String path, String content, boolean append) throws Exception {
        path = path.replaceAll("\r|\n|\r\n", "");
        try {
            String base = FileUtil.getJarPath();
            String decodeBase = null;
            try {
                decodeBase = URLDecoder.decode(base, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedEncodingException("URL\u89e3\u7801\u5931\u8d25\u3010" + base + "\u3011\uff1a" + e.getMessage());
            }
            File file = new File(decodeBase, path);
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception("\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff1a" + path);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, append));
            if (append) {
                bufferedWriter.newLine();
            }
            bufferedWriter.write(content);
            bufferedWriter.close();
        }
        catch (Exception e2) {
            throw new Exception("\u5199\u5165\u6587\u4ef6\u5185\u5bb9\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    private static String getJarPath() {
        String path = "";
        URL location = FileUtil.class.getProtectionDomain().getCodeSource().getLocation();
        File file = new File(location.getPath());
        path = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
        return path;
    }
}

