/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools;

import io.github.simonalexs.config.ToolConfig;
import io.github.simonalexs.enums.SAPropertyEnum;
import io.github.simonalexs.exceptions.MsgSendFailException;
import io.github.simonalexs.tools.senders.WxPusherUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NotifyUtil {
    public static void notify(String summary, String content) throws MsgSendFailException {
        String notifyType = ToolConfig.getParam(SAPropertyEnum.CLOCK_NOTIFY_TYPES, String.class);
        if (StringUtils.isBlank((CharSequence)notifyType)) {
            NotifyUtil.notifyWechat(summary, content);
        } else {
            NotifyTypeEnum notifyTypeEnum = NotifyTypeEnum.parse(notifyType);
            NotifyUtil.notify(summary, content, notifyTypeEnum);
        }
    }

    public static void notify(String summary, String content, NotifyTypeEnum notifyType) throws MsgSendFailException {
        NotifyUtil.notify(summary, content, Collections.singleton(notifyType));
    }

    public static void notify(String summary, String content, Collection<NotifyTypeEnum> notifyTypes) throws MsgSendFailException {
        for (NotifyTypeEnum notifyType : notifyTypes) {
            switch (notifyType) {
                case WX_PUSHER: {
                    NotifyUtil.notifyWechat(summary, content);
                    break;
                }
                case EMAIL: {
                    break;
                }
            }
        }
    }

    public static void notifyWechat(String summary, String content) throws MsgSendFailException {
        String appToken = ToolConfig.getParam(SAPropertyEnum.NOTIFY_WX_PUSHER_APP_TOKEN, String.class);
        String sendUIds = ToolConfig.getParam(SAPropertyEnum.NOTIFY_WX_PUSHER_SEND_UIDS, String.class);
        if (StringUtils.isBlank((CharSequence)appToken) || StringUtils.isBlank((CharSequence)sendUIds)) {
            WxPusherUtil.sendMd(summary, content);
        } else {
            WxPusherUtil.send(appToken, sendUIds, WxPusherUtil.WxPusherTypeEnum.MD, summary, content);
        }
    }

    public static void notifyWechat(String appToken, String sendUIdsStr, WxPusherUtil.WxPusherTypeEnum type, String summary, String content) throws MsgSendFailException {
        WxPusherUtil.send(appToken, sendUIdsStr, type, summary, content);
    }

    public static enum NotifyTypeEnum {
        WX_PUSHER,
        EMAIL,
        QQ,
        SMS_TENCENT;

        private static final Map<String, NotifyTypeEnum> map;

        public static NotifyTypeEnum parse(String str) {
            if (!map.containsKey(str.toUpperCase())) {
                throw new RuntimeException("not support value [" + str + "].Supported notify enum value: " + String.join((CharSequence)", ", map.keySet()));
            }
            return map.get(str.toUpperCase());
        }

        static {
            map = new LinkedHashMap<String, NotifyTypeEnum>();
            for (NotifyTypeEnum value : NotifyTypeEnum.values()) {
                String replacedName = value.name().replaceAll("_", "");
                map.put(value.name().toUpperCase(), value);
                map.put(replacedName.toUpperCase(), value);
            }
        }
    }
}

