/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools;

import java.math.BigInteger;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static String toLowerCaseFirst(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String toUpperCaseFirst(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String humpToSpace(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return StringUtil.humpToAny(str, " ");
    }

    public static String humpToUnderLine(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return StringUtil.humpToAny(str, "_");
    }

    private static String humpToAny(String str, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char thisChar = str.charAt(i);
            builder.append(thisChar);
            if (i >= str.length() - 1 || StringUtil.isUpperCase(thisChar) || !StringUtil.isUpperCase(str.charAt(i + 1))) continue;
            String nextLowerCase = String.valueOf(str.charAt(i + 1)).toLowerCase();
            builder.append(separator).append(nextLowerCase);
            ++i;
        }
        return builder.toString();
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static <T> T parse(String str, Class<T> clazz) {
        if (str == null || str.isEmpty() && clazz != String.class) {
            return null;
        }
        return clazz.cast(StringUtil.getParser(clazz).apply(str));
    }

    public static Function<String, Object> getParser(Class<?> targetTypeClass) {
        if (Boolean.class.equals(targetTypeClass) || Boolean.TYPE.equals(targetTypeClass)) {
            return str -> {
                if (str.equals("1")) {
                    return true;
                }
                if (str.equals("0")) {
                    return false;
                }
                return Boolean.valueOf(str);
            };
        }
        if (Integer.class.equals(targetTypeClass) || Integer.TYPE.equals(targetTypeClass)) {
            return Integer::valueOf;
        }
        if (Double.class.equals(targetTypeClass) || Double.TYPE.equals(targetTypeClass)) {
            return Double::valueOf;
        }
        if (Float.class.equals(targetTypeClass) || Float.TYPE.equals(targetTypeClass)) {
            return Float::valueOf;
        }
        if (Long.class.equals(targetTypeClass) || Long.TYPE.equals(targetTypeClass)) {
            return Long::valueOf;
        }
        if (Short.class.equals(targetTypeClass) || Short.TYPE.equals(targetTypeClass)) {
            return Short::valueOf;
        }
        if (Byte.class.equals(targetTypeClass) || Byte.TYPE.equals(targetTypeClass)) {
            return Byte::valueOf;
        }
        if (BigInteger.class.equals(targetTypeClass)) {
            return BigInteger::new;
        }
        return str -> str;
    }
}

