/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class TreeUtil {
    private static final String SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS = String.valueOf('\u0000');
    private static final int THRESHOLD_LENGTH_IN_FILTER_SUBNODE_FOR_LONG_IDS = 200;

    public static ArrayList<String> filterSubNodeForLongIds(Collection<String> collection, String separator) {
        return TreeUtil.filterSubNodeForLongIds(collection.toArray(new String[0]), separator);
    }

    public static ArrayList<String> filterSubNodeForLongIds(String[] inputArray, String separator) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (inputArray == null || inputArray.length == 0) {
            return resultList;
        }
        resultList = inputArray.length <= 200 ? TreeUtil.doFilterSubNodeByCommonLoop(inputArray, separator) : TreeUtil.doFilterSubNodeBySortAndTreeLevel(inputArray, separator);
        return resultList;
    }

    private static ArrayList<String> doFilterSubNodeByCommonLoop(String[] inputArray, String separator) {
        ArrayList<String> resultList = new ArrayList<String>();
        Arrays.stream(inputArray).forEach(t -> {
            if (Arrays.stream(inputArray).noneMatch(s -> s.startsWith(t + separator))) {
                resultList.add((String)t);
            }
        });
        return resultList;
    }

    private static ArrayList<String> doFilterSubNodeBySortAndTreeLevel(String[] inputArray, String separator) {
        int i;
        ArrayList<String> resultList = new ArrayList<String>();
        String[] customArray = new String[inputArray.length];
        boolean isSeparatorSame = SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS.equals(separator);
        if (isSeparatorSame) {
            customArray = Arrays.copyOf(inputArray, inputArray.length);
        } else {
            for (int i2 = 0; i2 < inputArray.length; ++i2) {
                customArray[i2] = inputArray[i2].replaceAll(separator, SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS);
            }
        }
        Arrays.sort(customArray, Comparator.naturalOrder());
        int thisNodeLevel = (customArray[0].length() - customArray[0].replaceAll(SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS, "").length()) / SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS.length();
        for (i = 0; i <= customArray.length - 2; ++i) {
            int postNodeLevel = (customArray[i + 1].length() - customArray[i + 1].replaceAll(SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS, "").length()) / SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS.length();
            if (postNodeLevel <= thisNodeLevel) {
                resultList.add(customArray[i]);
            } else if (!customArray[i + 1].startsWith(customArray[i] + SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS)) {
                resultList.add(customArray[i]);
            }
            thisNodeLevel = postNodeLevel;
        }
        resultList.add(customArray[customArray.length - 1]);
        if (!isSeparatorSame) {
            for (i = 0; i < resultList.size(); ++i) {
                resultList.set(i, resultList.get(i).replaceAll(SEPARATOR_IN_FILTER_SUBNODE_FOR_LONG_IDS, separator));
            }
        }
        return resultList;
    }
}

