/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.debug;

import io.github.simonalexs.base.baseStruct.StopWatchInfo;
import io.github.simonalexs.base.common.ConsolePrintTable;
import io.github.simonalexs.tools.debug.StopWatch;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StopWatchMulti {
    public static boolean ENABLE_PRINT_CODE_LINE = false;
    private static List<StopWatchInfo> stopWatchList = new ArrayList<StopWatchInfo>();
    private static List<String> taskNameList = new ArrayList<String>();

    public static void start(String taskName) {
        StopWatchInfo stopWatchInfo = new StopWatchInfo();
        stopWatchInfo.setTaskName(taskName);
        stopWatchInfo.setStartLineInfo(StopWatchMulti.getCurrentCodeLineInfo());
        stopWatchInfo.getStopWatch().start(taskName);
        stopWatchList.add(stopWatchInfo);
        if (!taskNameList.contains(taskName)) {
            taskNameList.add(taskName);
        }
    }

    public static void stop(String taskName) {
        for (int i = 0; i < stopWatchList.size(); ++i) {
            if (!stopWatchList.get(i).getTaskName().equals(taskName) || !stopWatchList.get(i).getStopWatch().isRunning()) continue;
            StopWatchMulti.stop(i + 1);
            return;
        }
        throw new RuntimeException("task name \u3010" + taskName + "\u3011 not exists or task name \u3010" + taskName + "\u3011 is not running");
    }

    public static void stopAndPrint(String taskName) {
        for (int i = 0; i < stopWatchList.size(); ++i) {
            if (!stopWatchList.get(i).getTaskName().equals(taskName) || !stopWatchList.get(i).getStopWatch().isRunning()) continue;
            StopWatchMulti.stopAndPrint(i + 1);
            return;
        }
        throw new RuntimeException("task name \u3010" + taskName + "\u3011 not exists or task name \u3010" + taskName + "\u3011 is not running");
    }

    public static void print() {
        String str = StopWatchMulti.generateResultStr(0);
        System.out.println(str);
    }

    public static void print(int avgSkipNum) {
        String str = StopWatchMulti.generateResultStr(avgSkipNum);
        System.out.println(str);
        if (avgSkipNum > 0) {
            System.out.println("\u6bcf\u4e2a\u4efb\u52a1\u7edf\u8ba1\u5e73\u5747\u8017\u65f6\u7684\u65f6\u5019\uff0c\u5747\u5df2\u5ffd\u7565\u524d\u3010" + avgSkipNum + "\u3011\u6761\u8017\u65f6\u4fe1\u606f");
        }
    }

    public static void clear() {
        stopWatchList.clear();
        taskNameList.clear();
    }

    private static void stop(int order) {
        StopWatchInfo stopWatchInfo = stopWatchList.get(order - 1);
        if (!stopWatchInfo.getStopWatch().isRunning()) {
            throw new RuntimeException("task \u3010" + order + "\u3011 is not running");
        }
        stopWatchInfo.getStopWatch().stop();
        stopWatchInfo.setEndLineInfo(StopWatchMulti.getCurrentCodeLineInfo());
    }

    private static void stopAndPrint(int order) {
        StopWatchMulti.stop(order);
        String commonConsumingStr = StopWatchMulti.getCommonConsumingStr(order);
        System.out.println(commonConsumingStr);
    }

    private static String generateResultStr(int avgSkipNum) {
        for (StopWatchInfo stopWatchInfo : stopWatchList) {
            if (!stopWatchInfo.getStopWatch().isRunning()) continue;
            throw new RuntimeException("task name \u3010" + stopWatchInfo.getTaskName() + "\u3011 is still running, please stop all tasks before print.");
        }
        String commonConsumingStr = StopWatchMulti.getCommonConsumingStr(null);
        String averageConsumingStr = StopWatchMulti.getAverageConsumingStr(avgSkipNum);
        return commonConsumingStr + "\n" + averageConsumingStr;
    }

    private static String getCommonConsumingStr(Integer order) {
        ConsolePrintTable.Builder builder = ConsolePrintTable.getInstance("Time-consuming list").getBuilder();
        builder.addTitle(Arrays.asList("Task order", "Task name", "s", "ms", "ns"));
        if (ENABLE_PRINT_CODE_LINE) {
            builder.addTitle("Task begin code");
            builder.addTitle("Task end code");
        }
        NumberFormat ddf2 = NumberFormat.getNumberInstance();
        ddf2.setMaximumFractionDigits(4);
        if (order == null) {
            for (int i = 0; i < stopWatchList.size(); ++i) {
                StopWatchInfo stopWatchInfo = stopWatchList.get(i);
                List<Object> rowData = StopWatchMulti.getRowData(stopWatchInfo, builder, i + 1, ddf2);
                builder.addRowData(rowData);
            }
        } else {
            StopWatchInfo stopWatchInfo = stopWatchList.get(order - 1);
            List<Object> rowData = StopWatchMulti.getRowData(stopWatchInfo, builder, order, ddf2);
            builder.addRowData(rowData);
        }
        return builder.build().prettyPrint();
    }

    private static List<Object> getRowData(StopWatchInfo stopWatchInfo, ConsolePrintTable.Builder builder, int order, NumberFormat ddf2) {
        StopWatch.TaskInfo task = stopWatchInfo.getStopWatch().getTaskInfo()[0];
        List<Object> rowData = Arrays.asList(order, task.getTaskName(), ddf2.format(task.getTimeSeconds()), task.getTimeMillis(), task.getTimeNanos());
        if (ENABLE_PRINT_CODE_LINE) {
            rowData.add(stopWatchInfo.getStartLineInfo());
            rowData.add(stopWatchInfo.getEndLineInfo());
        }
        return rowData;
    }

    private static String getAverageConsumingStr(int avgSkipNum) {
        ConsolePrintTable.Builder builder = ConsolePrintTable.getInstance("Average time-consuming list").getBuilder();
        builder.addTitle(Arrays.asList("Task order", "Task name", "s", "ms", "ns"));
        if (ENABLE_PRINT_CODE_LINE) {
            builder.addTitle("Task begin code");
            builder.addTitle("Task end code");
        }
        NumberFormat ddf0 = NumberFormat.getNumberInstance();
        ddf0.setMaximumFractionDigits(0);
        NumberFormat ddf1 = NumberFormat.getNumberInstance();
        ddf1.setMaximumFractionDigits(2);
        NumberFormat ddf2 = NumberFormat.getNumberInstance();
        ddf2.setMaximumFractionDigits(4);
        Map collect = stopWatchList.stream().collect(Collectors.groupingBy(StopWatchInfo::getTaskName, LinkedHashMap::new, Collectors.toList()));
        for (int i = 0; i < taskNameList.size(); ++i) {
            String taskName = taskNameList.get(i);
            List oriStopWatchInfoList = (List)collect.get(taskName);
            List stopWatchInfoList = oriStopWatchInfoList.stream().skip(avgSkipNum).collect(Collectors.toList());
            if (stopWatchInfoList.isEmpty()) continue;
            Double nanoAverage = stopWatchInfoList.stream().collect(Collectors.averagingLong(t -> t.getStopWatch().getTaskInfo()[0].getTimeNanos()));
            Double millisAverage = stopWatchInfoList.stream().collect(Collectors.averagingLong(t -> t.getStopWatch().getTaskInfo()[0].getTimeMillis()));
            Double secondAverage = stopWatchInfoList.stream().collect(Collectors.averagingDouble(t -> t.getStopWatch().getTaskInfo()[0].getTimeSeconds()));
            List<Object> rowData = Arrays.asList(i + 1, taskName, stopWatchInfoList.size(), ddf2.format(secondAverage), ddf1.format(millisAverage), ddf0.format(nanoAverage));
            if (ENABLE_PRINT_CODE_LINE) {
                rowData.add(((StopWatchInfo)stopWatchInfoList.get(0)).getStartLineInfo());
                rowData.add(((StopWatchInfo)stopWatchInfoList.get(0)).getEndLineInfo());
            }
            builder.addRowData(rowData);
        }
        return builder.build().prettyPrint();
    }

    private static String getCurrentCodeLineInfo() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isPassCurrentClass = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            boolean isEndsWithCurrentClass = stackTraceElement.getClassName().endsWith(StopWatchMulti.class.getName());
            if (isEndsWithCurrentClass) {
                if (isPassCurrentClass) continue;
                isPassCurrentClass = true;
                continue;
            }
            if (!isPassCurrentClass) continue;
            return stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + "(" + stackTraceElement.getLineNumber() + ")";
        }
        return "not find";
    }
}

