/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.debug;

import io.github.simonalexs.base.common.ConsolePrintTable;
import io.github.simonalexs.tools.debug.StopWatch;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StopWatchSingle {
    private static final StopWatch singleStopWatch = new StopWatch();
    private static final List<String> startLineInfos = new ArrayList<String>();
    private static final List<String> endLineInfos = new ArrayList<String>();

    public static String start(String taskName) {
        singleStopWatch.start(taskName);
        startLineInfos.add(StopWatchSingle.getCurrentCodeLineInfo());
        return "[\u4efb\u52a1\uff1a" + taskName + "]\u76d1\u6d4b\u8fd0\u884c\u65f6\u95f4\u5f00\u59cb......";
    }

    public static String start() {
        return StopWatchSingle.start("");
    }

    public static void stop() {
        singleStopWatch.stop();
        endLineInfos.add(StopWatchSingle.getCurrentCodeLineInfo());
    }

    public static String print() {
        double totalTimeNanos = singleStopWatch.getTotalTimeNanos();
        long totalTimeMillis = singleStopWatch.getTotalTimeMillis();
        double totalTimeSeconds = singleStopWatch.getTotalTimeSeconds();
        String shortSummary = "StopWatch '" + singleStopWatch.getId() + "': running time [ " + String.format("%9s", totalTimeMillis) + "ms / " + String.format("%9.3f", totalTimeSeconds) + "s ]";
        ConsolePrintTable.Builder builder = ConsolePrintTable.getInstance().getBuilder();
        builder.addTitle(Arrays.asList("Task name", "s", "ms", "ns", "%", "Task begin code", "Task end code"));
        NumberFormat ddf1 = NumberFormat.getNumberInstance();
        ddf1.setMaximumFractionDigits(2);
        NumberFormat ddf2 = NumberFormat.getNumberInstance();
        ddf2.setMaximumFractionDigits(4);
        for (int i = 0; i < singleStopWatch.getTaskInfo().length; ++i) {
            StopWatch.TaskInfo task = singleStopWatch.getTaskInfo()[i];
            List<Object> rowData = Arrays.asList(task.getTaskName(), ddf2.format(task.getTimeSeconds()), task.getTimeMillis(), task.getTimeNanos(), ddf1.format((double)task.getTimeNanos() / totalTimeNanos * 100.0), startLineInfos.get(i), endLineInfos.get(i));
            builder.addRowData(rowData);
        }
        return builder.build().prettyPrint();
    }

    private static String getCurrentCodeLineInfo() {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().endsWith(StopWatchSingle.class.getName())) continue;
            return stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + "(" + stackTraceElement.getLineNumber() + ")";
        }
        return "not find";
    }
}

