/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.other;

import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;

public class IpUtil {
    public static String getIpAddress() throws SocketException {
        String ipString = null;
        Inet4Address inet4Address = IpUtil.getInet4Address();
        if (inet4Address != null) {
            ipString = inet4Address.getHostAddress();
        }
        return ipString;
    }

    public static String getTomcatHttpPort() throws MalformedObjectNameException {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        String port = objectNames.iterator().next().getKeyProperty("port");
        return port;
    }

    public static int getNetworkPrefixLength() throws UnknownHostException, SocketException {
        int networkPrefixLength = 0;
        Inet4Address inet4Address = IpUtil.getInet4Address();
        if (inet4Address != null) {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inet4Address);
            for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                if (!(address.getAddress() instanceof Inet4Address)) continue;
                networkPrefixLength = address.getNetworkPrefixLength();
            }
        }
        return networkPrefixLength;
    }

    public static String getSubnet() throws UnknownHostException, SocketException {
        String subnet = null;
        int prefix = IpUtil.getNetworkPrefixLength();
        if (prefix > 0) {
            if (prefix == 8) {
                subnet = "255.0.0.0";
            } else if (prefix == 16) {
                subnet = "255.255.0.0";
            } else if (prefix == 24) {
                subnet = "255.255.255.0";
            } else if (prefix == 32) {
                subnet = "255.255.255.255";
            }
        }
        return subnet;
    }

    private static Inet4Address getInet4Address() throws SocketException {
        Inet4Address inet4Address = null;
        Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress ip = null;
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (ip == null || !(ip instanceof Inet4Address)) continue;
                inet4Address = (Inet4Address)ip;
                break;
            }
            if (inet4Address == null) continue;
            break;
        }
        return inet4Address;
    }

    public static void main(String[] args) throws SocketException, UnknownHostException {
        System.out.println(IpUtil.getIpAddress());
        System.out.println(IpUtil.getNetworkPrefixLength());
        System.out.println(IpUtil.getSubnet());
    }
}

