/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.other;

public class MdBuilder {
    private static final String LINE_BREAK = "<br/>";
    private static final String UNORDERED_LIST_REPAIR_CHAR = "\n";
    private static final int INITIAL_ORDER = 1;
    private String result = "";
    private int currentOrder = 1;

    public static MdBuilder getBuilder() {
        return MdBuilder.getBuilder("");
    }

    public static MdBuilder getBuilder(String text) {
        return new MdBuilder(text);
    }

    public MdBuilder(String text) {
        this.result = text;
    }

    public MdBuilder blod(String text) {
        this.result = this.result + "**" + text + "** ";
        return this;
    }

    public MdBuilder text(String text) {
        this.result = this.result + text;
        return this;
    }

    public MdBuilder link(String url) {
        this.result = this.result + "[" + url + "](" + url + ")";
        return this;
    }

    public MdBuilder link(String title, String url) {
        this.result = this.result + "[" + title + "](" + url + ")";
        return this;
    }

    public MdBuilder codeMutilLine(String text) {
        this.result = this.result + "```" + text + "```<br/>";
        return this;
    }

    public MdBuilder codeSingleLine(String text) {
        this.result = this.result + "`" + text + "`";
        return this;
    }

    public MdBuilder prepareForListWithOrdered() {
        this.currentOrder = 1;
        return this;
    }

    public MdBuilder listWithOrdered() {
        return this.listWithOrdered("");
    }

    public MdBuilder listWithOrdered(String text) {
        this.result = this.result + this.currentOrder++ + ". " + text;
        return this;
    }

    public MdBuilder prepareForListWithUnordered() {
        this.result = this.result + UNORDERED_LIST_REPAIR_CHAR;
        return this;
    }

    public MdBuilder listWithUnordered() {
        return this.listWithUnordered("");
    }

    public MdBuilder listWithUnordered(String text) {
        this.result = this.result + "\n*  " + text;
        return this;
    }

    public MdBuilder lineBreak() {
        this.result = this.result + LINE_BREAK;
        return this;
    }

    public String build() {
        return this.result;
    }
}

