/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.tools.senders;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.github.qcloudsms.SmsMultiSender;
import com.github.qcloudsms.SmsMultiSenderResult;
import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.github.qcloudsms.httpclient.HTTPException;
import com.tencentcloudapi.common.CommonClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.Region;
import com.tencentcloudapi.common.provider.EnvironmentVariableCredentialsProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SmsUtil {
    public static SmsSingleSenderResult sendByTencent2(String phoneNumber, int templateId, Collection<String> paramsForTemplate) {
        try {
            Credential credential = new EnvironmentVariableCredentialsProvider().getCredentials();
            return SmsUtil.sendByTencent2(credential, phoneNumber, templateId, paramsForTemplate);
        }
        catch (TencentCloudSDKException e) {
            return ResultProducer.buildSmsSingleSenderResult((Exception)((Object)e));
        }
    }

    public static SmsSingleSenderResult sendByTencent2(Credential credential, String phoneNumber, int templateId, Collection<String> paramsForTemplate) {
        try {
            SmsSingleSender sender = new SmsSingleSender(Integer.parseInt(credential.getSecretId()), credential.getSecretKey());
            return sender.sendWithParam("86", phoneNumber, templateId, new ArrayList<String>(paramsForTemplate), "", "", "");
        }
        catch (HTTPException | IOException e) {
            return ResultProducer.buildSmsSingleSenderResult((Exception)e);
        }
    }

    public static SmsMultiSenderResult sendByTencent2(Collection<String> phoneNumbers, int templateId, Collection<String> paramsForTemplate) {
        try {
            Credential credential = new EnvironmentVariableCredentialsProvider().getCredentials();
            return SmsUtil.sendByTencent2(credential, phoneNumbers, templateId, paramsForTemplate);
        }
        catch (TencentCloudSDKException e) {
            return ResultProducer.buildSmsMultiSenderResult((Exception)((Object)e));
        }
    }

    public static SmsMultiSenderResult sendByTencent2(Credential credential, Collection<String> phoneNumbers, int templateId, Collection<String> paramsForTemplate) {
        try {
            SmsMultiSender sender = new SmsMultiSender(Integer.parseInt(credential.getSecretId()), credential.getSecretKey());
            return sender.sendWithParam("86", new ArrayList<String>(phoneNumbers), templateId, new ArrayList<String>(paramsForTemplate), "", "", "");
        }
        catch (HTTPException | IOException e) {
            return ResultProducer.buildSmsMultiSenderResult((Exception)e);
        }
    }

    public static String sendByTencent3(String productName, String version, Region region, Map<String, Object> jsonPayload) {
        try {
            Credential credential = new EnvironmentVariableCredentialsProvider().getCredentials();
            return SmsUtil.sendByTencent3(productName, version, credential, region, jsonPayload);
        }
        catch (TencentCloudSDKException e) {
            return e.getMessage();
        }
    }

    public static String sendByTencent3(String productName, String version, Credential credential, Region region, Map<String, Object> jsonPayload) {
        try {
            CommonClient client = new CommonClient(productName, version, credential, region.getValue());
            return client.call("SendSms", JSON.toJSONString(jsonPayload, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        }
        catch (TencentCloudSDKException e) {
            return e.getMessage();
        }
    }

    private static class ResultProducer {
        private ResultProducer() {
        }

        public static SmsMultiSenderResult buildSmsMultiSenderResult(Exception e) {
            SmsMultiSenderResult result = new SmsMultiSenderResult();
            result.result = -1;
            result.errMsg = e.getMessage();
            return result;
        }

        public static SmsSingleSenderResult buildSmsSingleSenderResult(Exception e) {
            SmsSingleSenderResult result = new SmsSingleSenderResult();
            result.result = -1;
            result.errMsg = e.getMessage();
            return result;
        }
    }
}

