/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.JavaMethodRef;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.CodeAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationDefaultAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaParamAnnsAttr;
import jadx.plugins.input.java.data.code.JavaCodeReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaMethodData
implements IMethodData {
    private final JavaClassData clsData;
    private final JavaMethodRef methodRef;
    private int accessFlags;
    private JavaAttrStorage attributes;

    public JavaMethodData(JavaClassData clsData, JavaMethodRef methodRef) {
        this.clsData = clsData;
        this.methodRef = methodRef;
    }

    public void setData(int accessFlags, JavaAttrStorage attributes) {
        this.accessFlags = accessFlags;
        this.attributes = attributes;
    }

    public JavaMethodRef getMethodRef() {
        return this.methodRef;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Nullable
    public ICodeReader getCodeReader() {
        CodeAttr codeAttr = this.attributes.get(JavaAttrType.CODE);
        if (codeAttr == null) {
            return null;
        }
        return new JavaCodeReader(this.clsData, codeAttr.getOffset());
    }

    public String disassembleMethod() {
        return "";
    }

    public List<IJadxAttribute> getAttributes() {
        int size = this.attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<IJadxAttribute> list = new ArrayList<IJadxAttribute>(size);
        Utils.addToList(list, (Object)JavaAnnotationsAttr.merge(this.attributes));
        Utils.addToList(list, (Object)JavaParamAnnsAttr.merge(this.attributes));
        Utils.addToList(list, (Object)JavaAnnotationDefaultAttr.convert(this.attributes));
        Utils.addToList(list, (Object)this.attributes.get(JavaAttrType.SIGNATURE));
        Utils.addToList(list, (Object)this.attributes.get(JavaAttrType.EXCEPTIONS));
        return list;
    }

    public String toString() {
        return this.getMethodRef().toString();
    }
}

