/*
 * Decompiled with CFR 0.152.
 */
package imgui.extension.texteditor;

import imgui.ImVec2;
import imgui.binding.ImGuiStructDestroyable;
import imgui.extension.texteditor.TextEditorCoordinates;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.util.Map;

public final class TextEditor
extends ImGuiStructDestroyable {
    public TextEditor() {
    }

    public TextEditor(long ptr) {
        super(ptr);
    }

    @Override
    protected long create() {
        return this.nCreate();
    }

    private native long nCreate();

    public void setLanguageDefinition(TextEditorLanguageDefinition aLanguageDef) {
        this.nSetLanguageDefinition(aLanguageDef.ptr);
    }

    private native void nSetLanguageDefinition(long var1);

    public TextEditorLanguageDefinition getLanguageDefinition() {
        return new TextEditorLanguageDefinition(this.nGetLanguageDefinition());
    }

    private native long nGetLanguageDefinition();

    public native int[] getPalette();

    public void setPalette(int[] palette) {
        this.nSetPalette(palette, palette.length);
    }

    public native void nSetPalette(int[] var1, int var2);

    public void setErrorMarkers(Map<Integer, String> errorMarkers) {
        int[] keys = errorMarkers.keySet().stream().mapToInt(i -> i).toArray();
        String[] values = errorMarkers.values().toArray(new String[0]);
        this.nSetErrorMarkers(keys, keys.length, values, values.length);
    }

    private native void nSetErrorMarkers(int[] var1, int var2, String[] var3, int var4);

    public void setBreakpoints(int[] breakpoints) {
        this.nSetBreakpoints(breakpoints, breakpoints.length);
    }

    private native void nSetBreakpoints(int[] var1, int var2);

    public void render(String title) {
        this.nRender(title);
    }

    public void render(String title, ImVec2 aSize) {
        this.nRender(title, aSize.x, aSize.y);
    }

    public void render(String title, float aSizeX, float aSizeY) {
        this.nRender(title, aSizeX, aSizeY);
    }

    public void render(String title, ImVec2 aSize, boolean aBorder) {
        this.nRender(title, aSize.x, aSize.y, aBorder);
    }

    public void render(String title, float aSizeX, float aSizeY, boolean aBorder) {
        this.nRender(title, aSizeX, aSizeY, aBorder);
    }

    public void render(String title, boolean aBorder) {
        this.nRender(title, aBorder);
    }

    private native void nRender(String var1);

    private native void nRender(String var1, float var2, float var3);

    private native void nRender(String var1, float var2, float var3, boolean var4);

    private native void nRender(String var1, boolean var2);

    public void setText(String text) {
        this.nSetText(text);
    }

    private native void nSetText(String var1);

    public String getText() {
        return this.nGetText();
    }

    private native String nGetText();

    public void setTextLines(String[] lines) {
        this.nSetTextLines(lines, lines.length);
    }

    private native void nSetTextLines(String[] var1, int var2);

    public native String[] getTextLines();

    public String getSelectedText() {
        return this.nGetSelectedText();
    }

    private native String nGetSelectedText();

    public String getCurrentLineText() {
        return this.nGetCurrentLineText();
    }

    private native String nGetCurrentLineText();

    public int getTotalLines() {
        return this.nGetTotalLines();
    }

    private native int nGetTotalLines();

    public boolean isOverwrite() {
        return this.nIsOverwrite();
    }

    private native boolean nIsOverwrite();

    public void setReadOnly(boolean aValue) {
        this.nSetReadOnly(aValue);
    }

    private native void nSetReadOnly(boolean var1);

    public boolean isReadOnly() {
        return this.nIsReadOnly();
    }

    private native boolean nIsReadOnly();

    public boolean isTextChanged() {
        return this.nIsTextChanged();
    }

    private native boolean nIsTextChanged();

    public boolean isCursorPositionChanged() {
        return this.nIsCursorPositionChanged();
    }

    private native boolean nIsCursorPositionChanged();

    public boolean isColorizerEnabled() {
        return this.nIsColorizerEnabled();
    }

    private native boolean nIsColorizerEnabled();

    public void setColorizerEnable(boolean aValue) {
        this.nSetColorizerEnable(aValue);
    }

    private native void nSetColorizerEnable(boolean var1);

    public TextEditorCoordinates getCursorPosition() {
        TextEditorCoordinates dst = new TextEditorCoordinates();
        this.nGetCursorPosition(dst);
        return dst;
    }

    public void getCursorPosition(TextEditorCoordinates dst) {
        this.nGetCursorPosition(dst);
    }

    private native void nGetCursorPosition(TextEditorCoordinates var1);

    public void setCursorPosition(TextEditorCoordinates aPosition) {
        this.nSetCursorPosition(aPosition.mLine, aPosition.mColumn);
    }

    public void setCursorPosition(int aPositionLine, int aPositionColumn) {
        this.nSetCursorPosition(aPositionLine, aPositionColumn);
    }

    private native void nSetCursorPosition(int var1, int var2);

    public void setHandleMouseInputs(boolean aValue) {
        this.nSetHandleMouseInputs(aValue);
    }

    private native void nSetHandleMouseInputs(boolean var1);

    public boolean isHandleMouseInputsEnabled() {
        return this.nIsHandleMouseInputsEnabled();
    }

    private native boolean nIsHandleMouseInputsEnabled();

    public void setHandleKeyboardInputs(boolean aValue) {
        this.nSetHandleKeyboardInputs(aValue);
    }

    private native void nSetHandleKeyboardInputs(boolean var1);

    public boolean isHandleKeyboardInputsEnabled() {
        return this.nIsHandleKeyboardInputsEnabled();
    }

    private native boolean nIsHandleKeyboardInputsEnabled();

    public void setImGuiChildIgnored(boolean aValue) {
        this.nSetImGuiChildIgnored(aValue);
    }

    private native void nSetImGuiChildIgnored(boolean var1);

    public boolean isImGuiChildIgnored() {
        return this.nIsImGuiChildIgnored();
    }

    private native boolean nIsImGuiChildIgnored();

    public void setShowWhitespaces(boolean aValue) {
        this.nSetShowWhitespaces(aValue);
    }

    private native void nSetShowWhitespaces(boolean var1);

    public boolean isShowingWhitespaces() {
        return this.nIsShowingWhitespaces();
    }

    private native boolean nIsShowingWhitespaces();

    public void setTabSize(int aValue) {
        this.nSetTabSize(aValue);
    }

    private native void nSetTabSize(int var1);

    public int getTabSize() {
        return this.nGetTabSize();
    }

    private native int nGetTabSize();

    public void insertText(String aValue) {
        this.nInsertText(aValue);
    }

    private native void nInsertText(String var1);

    public void moveUp() {
        this.nMoveUp();
    }

    public void moveUp(int aAmount) {
        this.nMoveUp(aAmount);
    }

    public void moveUp(int aAmount, boolean aSelect) {
        this.nMoveUp(aAmount, aSelect);
    }

    private native void nMoveUp();

    private native void nMoveUp(int var1);

    private native void nMoveUp(int var1, boolean var2);

    public void moveDown() {
        this.nMoveDown();
    }

    public void moveDown(int aAmount) {
        this.nMoveDown(aAmount);
    }

    public void moveDown(int aAmount, boolean aSelect) {
        this.nMoveDown(aAmount, aSelect);
    }

    private native void nMoveDown();

    private native void nMoveDown(int var1);

    private native void nMoveDown(int var1, boolean var2);

    public void moveLeft() {
        this.nMoveLeft();
    }

    public void moveLeft(int aAmount) {
        this.nMoveLeft(aAmount);
    }

    public void moveLeft(int aAmount, boolean aSelect) {
        this.nMoveLeft(aAmount, aSelect);
    }

    public void moveLeft(int aAmount, boolean aSelect, boolean aWordMode) {
        this.nMoveLeft(aAmount, aSelect, aWordMode);
    }

    private native void nMoveLeft();

    private native void nMoveLeft(int var1);

    private native void nMoveLeft(int var1, boolean var2);

    private native void nMoveLeft(int var1, boolean var2, boolean var3);

    public void moveRight() {
        this.nMoveRight();
    }

    public void moveRight(int aAmount) {
        this.nMoveRight(aAmount);
    }

    public void moveRight(int aAmount, boolean aSelect) {
        this.nMoveRight(aAmount, aSelect);
    }

    public void moveRight(int aAmount, boolean aSelect, boolean aWordMode) {
        this.nMoveRight(aAmount, aSelect, aWordMode);
    }

    private native void nMoveRight();

    private native void nMoveRight(int var1);

    private native void nMoveRight(int var1, boolean var2);

    private native void nMoveRight(int var1, boolean var2, boolean var3);

    public void moveTop() {
        this.nMoveTop();
    }

    public void moveTop(boolean aSelect) {
        this.nMoveTop(aSelect);
    }

    private native void nMoveTop();

    private native void nMoveTop(boolean var1);

    public void moveBottom() {
        this.nMoveBottom();
    }

    public void moveBottom(boolean aSelect) {
        this.nMoveBottom(aSelect);
    }

    private native void nMoveBottom();

    private native void nMoveBottom(boolean var1);

    public void moveHome() {
        this.nMoveHome();
    }

    public void moveHome(boolean aSelect) {
        this.nMoveHome(aSelect);
    }

    private native void nMoveHome();

    private native void nMoveHome(boolean var1);

    public void moveEnd() {
        this.nMoveEnd();
    }

    public void moveEnd(boolean aSelect) {
        this.nMoveEnd(aSelect);
    }

    private native void nMoveEnd();

    private native void nMoveEnd(boolean var1);

    public void setSelectionStart(TextEditorCoordinates aPosition) {
        this.nSetSelectionStart(aPosition.mLine, aPosition.mColumn);
    }

    public void setSelectionStart(int aPositionLine, int aPositionColumn) {
        this.nSetSelectionStart(aPositionLine, aPositionColumn);
    }

    private native void nSetSelectionStart(int var1, int var2);

    public void setSelectionEnd(TextEditorCoordinates aPosition) {
        this.nSetSelectionEnd(aPosition.mLine, aPosition.mColumn);
    }

    public void setSelectionEnd(int aPositionLine, int aPositionColumn) {
        this.nSetSelectionEnd(aPositionLine, aPositionColumn);
    }

    private native void nSetSelectionEnd(int var1, int var2);

    public void setSelection(TextEditorCoordinates aStart, TextEditorCoordinates aEnd) {
        this.nSetSelection(aStart.mLine, aStart.mColumn, aEnd.mLine, aEnd.mColumn);
    }

    public void setSelection(int aStartLine, int aStartColumn, int aEndLine, int aEndColumn) {
        this.nSetSelection(aStartLine, aStartColumn, aEndLine, aEndColumn);
    }

    public void setSelection(TextEditorCoordinates aStart, TextEditorCoordinates aEnd, int aMode) {
        this.nSetSelection(aStart.mLine, aStart.mColumn, aEnd.mLine, aEnd.mColumn, aMode);
    }

    public void setSelection(int aStartLine, int aStartColumn, int aEndLine, int aEndColumn, int aMode) {
        this.nSetSelection(aStartLine, aStartColumn, aEndLine, aEndColumn, aMode);
    }

    private native void nSetSelection(int var1, int var2, int var3, int var4);

    private native void nSetSelection(int var1, int var2, int var3, int var4, int var5);

    public void selectWordUnderCursor() {
        this.nSelectWordUnderCursor();
    }

    private native void nSelectWordUnderCursor();

    public void selectAll() {
        this.nSelectAll();
    }

    private native void nSelectAll();

    public boolean hasSelection() {
        return this.nHasSelection();
    }

    private native boolean nHasSelection();

    public void copy() {
        this.nCopy();
    }

    private native void nCopy();

    public void cut() {
        this.nCut();
    }

    private native void nCut();

    public void paste() {
        this.nPaste();
    }

    private native void nPaste();

    public void delete() {
        this.nDelete();
    }

    private native void nDelete();

    public boolean canUndo() {
        return this.nCanUndo();
    }

    private native boolean nCanUndo();

    public boolean canRedo() {
        return this.nCanRedo();
    }

    private native boolean nCanRedo();

    public void undo() {
        this.nUndo();
    }

    public void undo(int aSteps) {
        this.nUndo(aSteps);
    }

    private native void nUndo();

    private native void nUndo(int var1);

    public void redo() {
        this.nRedo();
    }

    public void redo(int aSteps) {
        this.nRedo(aSteps);
    }

    private native void nRedo();

    private native void nRedo(int var1);

    public native int[] getDarkPalette();

    public native int[] getLightPalette();

    public native int[] getRetroBluePalette();
}

