/*
 * splitit-web-api-public-sdk
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0.0
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.splitit;

import com.splitit.sdk.api.*;

import java.math.BigDecimal;
import java.math.RoundingMode;

import com.splitit.ApiClient;
import com.splitit.ApiException;
import com.splitit.sdk.model.*;
import org.threeten.bp.OffsetDateTime;


public class FlexFields {
    private InitiateInstallmentPlanRequest activeRequest;
    private ApiClient apiClient;
    public FlexFields(ApiClient apiClient) {
        activeRequest = new InitiateInstallmentPlanRequest()
        .planData(
            new PlanData()
        );
        this.apiClient = apiClient;
    }

    public FlexFields addInstallments(String installmentOptions, int defaultNumInstallments) {
        activeRequest.getPlanData().numberOfInstallments(defaultNumInstallments);
        if (activeRequest.getPaymentWizardData() == null){
            activeRequest.paymentWizardData(new PaymentWizardData());
        }
        activeRequest.getPaymentWizardData().requestedNumberOfInstallments(installmentOptions);
        return this;
    }

    public FlexFields addBillingInformation(AddressData billingAddress, ConsumerData consumerData) {
        activeRequest
            .billingAddress(billingAddress)
            .consumerData(consumerData);
        return this;
    }
// func (ff *FlexFields) GetPublicToken(ctx _context.Context, amount float64, currencyCode string) (string, error) {
// 	ff.ActiveInitRequest.PlanData.Amount = &MoneyWithCurrencyCode{amount, currencyCode}

// 	initResponse, _, err := ff.Client.InstallmentPlanApi.InstallmentPlanInitiate(ctx, ff.ActiveInitRequest)

// 	if err != nil {
// 		return "", err
// 	}

// 	return initResponse.PublicToken, nil
// }

    public String getPublicToken(BigDecimal amount, String currencyCode) throws ApiException {
        activeRequest
            .getPlanData()
            .amount(
                new MoneyWithCurrencyCode()
                    .value(amount)
                    .currencyCode(currencyCode)
            );
        InitiateInstallmentsPlanResponse resp = apiClient.getInstallmentPlanApi().installmentPlanInitiate(activeRequest);
        return resp.getPublicToken();
    }


// func (ff *FlexFields) VerifyPayment(ctx _context.Context, planNumber string, orderAmount float64) (bool, error) {
// 	req := VerifyPaymentRequest{
// 		InstallmentPlanNumber: planNumber,
// 	}
// 	res, _, err := ff.Client.InstallmentPlanApi.InstallmentPlanVerifyPayment(ctx, req)
// 	if err != nil {
// 		return false, err
// 	}

// 	return res.IsPaid && res.OriginalAmountPaid == orderAmount, err
// }

    public boolean verifyPayment(String planNumber, BigDecimal amount) throws ApiException {
        VerifyPaymentResponse resp = apiClient.getInstallmentPlanApi().installmentPlanVerifyPayment(
            new VerifyPaymentRequest()
            .installmentPlanNumber(planNumber)
        );
        return resp.isIsPaid() && (
            amount.setScale(3, RoundingMode.HALF_UP).compareTo(resp.getOriginalAmountPaid()) == 0
        );
    }


// func (ff *FlexFields) Add3DSecure(redirectUrls *RedirectUrls) {
// 	ff.ActiveInitRequest.PlanData.Attempt3DSecure = true
// 	ff.ActiveInitRequest.RedirectUrls = redirectUrls
// }

    public FlexFields add3DSecure(RedirectUrls redirectUrls) {
        activeRequest
            .getPlanData().attempt3DSecure(true);
        activeRequest.redirectUrls(redirectUrls);
        return this;
    }

    public FlexFields autoCapture(boolean autocapture) {
        activeRequest
            .getPlanData().autoCapture(autocapture);
        return this;
    }

    public FlexFields firstInstallmentAmount(BigDecimal amount, String currencyCode) {
        activeRequest
            .getPlanData().firstInstallmentAmount(
                new MoneyWithCurrencyCode()
                .value(amount)
                .currencyCode(currencyCode)

            );
        return this;
    }
    public FlexFields firstChargeDate(OffsetDateTime chargeDate) {
        activeRequest
            .getPlanData().firstChargeDate(
                chargeDate
            );
        return this;
    }
}
