/*
 * Decompiled with CFR 0.152.
 */
package io.github.stackinfo.maven.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="prepare", aggregator=true)
public class PrepareMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File targetDirectory;
    @Parameter(defaultValue="${session.executionRootDirectory}", property="outputDir", required=true)
    private File rootDirectory;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;

    public void execute() throws MojoExecutionException {
        File outputDirectory = new File(this.targetDirectory, "stackinfo/poms");
        try {
            this.createOrCleanDirectory(outputDirectory);
            this.rootDirectory = this.rootDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            return;
        }
        MavenXpp3Writer writer = new MavenXpp3Writer();
        for (MavenProject project : this.projects) {
            Model model = project.getModel();
            try {
                File projectDirectory = model.getProjectDirectory().getCanonicalFile();
                if (!projectDirectory.toString().startsWith(this.rootDirectory.toString())) {
                    this.getLog().error((CharSequence)("Invalid project directory: " + projectDirectory));
                    continue;
                }
                String relative = this.rootDirectory.toURI().relativize(projectDirectory.toURI()).getPath();
                File projectOutputDirectory = new File(outputDirectory, relative);
                projectOutputDirectory.mkdirs();
                FileOutputStream out = new FileOutputStream(new File(projectOutputDirectory, "pom.xml"));
                writer.write((OutputStream)out, model);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    private void createOrCleanDirectory(File directory) throws IOException {
        if (directory.isDirectory()) {
            FileUtils.cleanDirectory((File)directory);
        } else {
            if (directory.exists()) {
                throw new IOException("Not a directory: " + directory);
            }
            if (!directory.mkdirs()) {
                throw new IOException("Unable to create output directory: " + directory);
            }
        }
    }
}

