/*
 * Decompiled with CFR 0.152.
 */
package svarzee.gps.gpsoauth;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import net.iharder.Base64;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import svarzee.gps.gpsoauth.AuthToken;
import svarzee.gps.gpsoauth.CipherUtil;
import svarzee.gps.gpsoauth.Try;
import svarzee.gps.gpsoauth.Util;
import svarzee.gps.gpsoauth.config.GpsoauthConfig;
import svarzee.gps.gpsoauth.config.GpsoauthConfigFactory;
import svarzee.gps.gpsoauth.config.GpsoauthConfigFileFactory;
import xxx.sun.security.ssl.SSLSocketFactoryImpl;

public class Gpsoauth {
    private final Util util = new Util();
    private final CipherUtil cipherUtil = new CipherUtil();
    private final GpsoauthConfig config;
    private final OkHttpClient httpClient;

    private static X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        try {
            Class<?> sslContextClass = Class.forName("xxx.sun.security.ssl.SSLContextImpl");
            Object context = Gpsoauth.readFieldOrNull(sslSocketFactory, sslContextClass, "context");
            if (context == null) {
                throw new IllegalStateException("Failed to create X509TrustManager.");
            }
            X509TrustManager trustManager = Gpsoauth.readFieldOrNull(context, X509TrustManager.class, "trustManager");
            if (trustManager == null) {
                throw new IllegalStateException("Failed to create X509TrustManager.");
            }
            return trustManager;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create X509TrustManager.");
        }
    }

    private static <T> T readFieldOrNull(Object instance, Class<T> fieldType, String fieldName) {
        Object delegate;
        for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null || !fieldType.isInstance(value)) {
                    return null;
                }
                return fieldType.cast(value);
            }
            catch (NoSuchFieldException field) {
                continue;
            }
            catch (Exception e) {
                throw new AssertionError();
            }
        }
        if (!fieldName.equals("delegate") && (delegate = Gpsoauth.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return Gpsoauth.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    private static OkHttpClient createOkHttpClient() {
        SSLSocketFactoryImpl sslSocketFactory;
        try {
            sslSocketFactory = new SSLSocketFactoryImpl();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create SSLSocketFactoryImpl.");
        }
        return new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)sslSocketFactory, Gpsoauth.trustManager(sslSocketFactory)).build();
    }

    public Gpsoauth() {
        this(Gpsoauth.createOkHttpClient());
    }

    public Gpsoauth(OkHttpClient httpClient) {
        this(httpClient, new GpsoauthConfigFileFactory("gpsoauth.properties"));
    }

    public Gpsoauth(OkHttpClient httpClient, GpsoauthConfigFactory gpsoauthConfigFactory) {
        this.config = gpsoauthConfigFactory.load();
        this.httpClient = httpClient;
    }

    public AuthToken login(String username, String password, String androidId, String service, String app, String clientSig) throws IOException, TokenRequestFailed {
        String masterToken = this.performMasterLoginForToken(username, password, androidId);
        return this.performOAuthForToken(username, masterToken, androidId, service, app, clientSig);
    }

    public Response performMasterLogin(String username, String password, String androidId) throws IOException {
        return this.performMasterLogin(username, password, androidId, "ac2dm", "us", "us", "en", "17");
    }

    public Response performMasterLogin(String username, String password, String androidId, String service, String deviceCountry, String operatorCountry, String lang, String sdkVersion) throws IOException {
        byte[] signature = this.cipherUtil.createSignature(username, password, this.config.getModulus(), this.config.getExponent());
        String b64Signature = Base64.encodeBytes((byte[])signature, (int)16);
        FormBody formBody = new FormBody.Builder().add("accountType", "HOSTED_OR_GOOGLE").add("Email", username).add("has_permission", "1").add("add_account", "1").add("EncryptedPasswd", b64Signature).add("service", service).add("source", "android").add("androidId", androidId).add("device_country", deviceCountry).add("operatorCountry", operatorCountry).add("lang", lang).add("sdk_version", sdkVersion).build();
        Request request = new Request.Builder().url("https://android.clients.google.com/auth").post((RequestBody)formBody).header("User-Agent", this.config.getUserAgent()).build();
        return this.httpClient.newCall(request).execute();
    }

    public String performMasterLoginForToken(String username, String password, String androidId) throws IOException, TokenRequestFailed {
        return this.performMasterLoginForToken(username, password, androidId, "ac2dm", "us", "us", "en", "17");
    }

    public String performMasterLoginForToken(String username, String password, String androidId, String service, String deviceCountry, String operatorCountry, String lang, String sdkVersion) throws IOException, TokenRequestFailed {
        try (Response response = this.performMasterLogin(username, password, androidId, service, deviceCountry, operatorCountry, lang, sdkVersion);){
            if (response.code() != 200) {
                throw new TokenRequestFailed();
            }
            String responseBody = response.body().string();
            Try<String> token = this.util.extractValue(responseBody, "Token");
            if (token.isFailure()) {
                throw new TokenRequestFailed();
            }
            String string = token.get();
            return string;
        }
    }

    public Response performOAuth(String username, String masterToken, String androidId, String service, String app, String clientSig) throws IOException {
        return this.performOAuth(username, masterToken, androidId, service, app, clientSig, "us", "us", "en", "17");
    }

    public Response performOAuth(String username, String masterToken, String androidId, String service, String app, String clientSig, String deviceCountry, String operatorCountry, String lang, String sdkVersion) throws IOException {
        FormBody formBody = new FormBody.Builder().add("accountType", "HOSTED_OR_GOOGLE").add("Email", username).add("has_permission", "1").add("EncryptedPasswd", masterToken).add("service", service).add("source", "android").add("androidId", androidId).add("app", app).add("client_sig", clientSig).add("device_country", deviceCountry).add("operatorCountry", operatorCountry).add("lang", lang).add("sdk_version", sdkVersion).build();
        Request request = new Request.Builder().url("https://android.clients.google.com/auth").post((RequestBody)formBody).header("User-Agent", this.config.getUserAgent()).build();
        return this.httpClient.newCall(request).execute();
    }

    public AuthToken performOAuthForToken(String username, String masterToken, String androidId, String service, String app, String clientSig) throws IOException, TokenRequestFailed {
        return this.performOAuthForToken(username, masterToken, androidId, service, app, clientSig, "us", "us", "en", "17");
    }

    public AuthToken performOAuthForToken(String username, String masterToken, String androidId, String service, String app, String clientSig, String deviceCountry, String operatorCountry, String lang, String sdkVersion) throws IOException, TokenRequestFailed {
        try (Response response = this.performOAuth(username, masterToken, androidId, service, app, clientSig, deviceCountry, operatorCountry, lang, sdkVersion);){
            if (response.code() != 200) {
                throw new TokenRequestFailed();
            }
            String responseBody = response.body().string();
            Try<String> token = this.util.extractValue(responseBody, "Auth");
            Try<String> expiry = this.util.extractValue(responseBody, "Expiry");
            if (token.isFailure() || expiry.isFailure()) {
                throw new TokenRequestFailed();
            }
            AuthToken authToken = new AuthToken(token.get(), expiry.isFailure() ? -1L : Long.parseLong(expiry.get()));
            return authToken;
        }
    }

    public static class TokenRequestFailed
    extends Exception {
    }
}

