/*
 * Decompiled with CFR 0.152.
 */
package svarzee.gps.gpsoauth.config;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Properties;
import svarzee.gps.gpsoauth.config.GpsoauthConfig;
import svarzee.gps.gpsoauth.config.GpsoauthConfigFactory;

public class GpsoauthConfigFileFactory
implements GpsoauthConfigFactory {
    private final String configFile;

    public GpsoauthConfigFileFactory(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public GpsoauthConfig load() {
        return this.fromFile(this.configFile);
    }

    private GpsoauthConfig fromFile(String configFile) {
        Properties properties = this.getProperties(configFile);
        BigInteger modulus = new BigInteger(properties.getProperty("modulus"));
        BigInteger exponent = new BigInteger(properties.getProperty("exponent"));
        String userAgent = properties.getProperty("user-agent");
        return new GpsoauthConfig(modulus, exponent, userAgent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties(String configFile) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(configFile);){
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

