/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import xxx.sun.security.ssl.CipherSuite;
import xxx.sun.security.ssl.HandshakeInStream;
import xxx.sun.security.ssl.HandshakeOutStream;

final class CipherSuiteList {
    private final Collection<CipherSuite> cipherSuites;
    private String[] suiteNames;
    private volatile Boolean containsEC;

    CipherSuiteList(Collection<CipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    CipherSuiteList(CipherSuite suite) {
        this.cipherSuites = new ArrayList<CipherSuite>(1);
        this.cipherSuites.add(suite);
    }

    CipherSuiteList(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("CipherSuites may not be null");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String suiteName = names[i];
            CipherSuite suite = CipherSuite.valueOf(suiteName);
            if (!suite.isAvailable()) {
                throw new IllegalArgumentException("Cannot support " + suiteName + " with currently installed providers");
            }
            this.cipherSuites.add(suite);
        }
    }

    CipherSuiteList(HandshakeInStream in) throws IOException {
        byte[] bytes = in.getBytes16();
        if ((bytes.length & 1) != 0) {
            throw new SSLException("Invalid ClientHello message");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(bytes.length >> 1);
        for (int i = 0; i < bytes.length; i += 2) {
            this.cipherSuites.add(CipherSuite.valueOf(bytes[i], bytes[i + 1]));
        }
    }

    boolean contains(CipherSuite suite) {
        return this.cipherSuites.contains(suite);
    }

    boolean containsEC() {
        if (this.containsEC == null) {
            for (CipherSuite c : this.cipherSuites) {
                if (!c.keyExchange.isEC) continue;
                this.containsEC = true;
                return true;
            }
            this.containsEC = false;
        }
        return this.containsEC;
    }

    Iterator<CipherSuite> iterator() {
        return this.cipherSuites.iterator();
    }

    Collection<CipherSuite> collection() {
        return this.cipherSuites;
    }

    int size() {
        return this.cipherSuites.size();
    }

    synchronized String[] toStringArray() {
        if (this.suiteNames == null) {
            this.suiteNames = new String[this.cipherSuites.size()];
            int i = 0;
            for (CipherSuite c : this.cipherSuites) {
                this.suiteNames[i++] = c.name;
            }
        }
        return (String[])this.suiteNames.clone();
    }

    public String toString() {
        return this.cipherSuites.toString();
    }

    void send(HandshakeOutStream s) throws IOException {
        byte[] suiteBytes = new byte[this.cipherSuites.size() * 2];
        int i = 0;
        for (CipherSuite c : this.cipherSuites) {
            suiteBytes[i] = (byte)(c.id >> 8);
            suiteBytes[i + 1] = (byte)c.id;
            i += 2;
        }
        s.putBytes16(suiteBytes);
    }
}

