/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import xxx.sun.security.ssl.Debug;
import xxx.sun.security.ssl.HandshakeInStream;
import xxx.sun.security.ssl.HandshakeMessage;
import xxx.sun.security.ssl.HandshakeOutStream;
import xxx.sun.security.ssl.JsseJce;

final class ECDHClientKeyExchange
extends HandshakeMessage {
    private byte[] encodedPoint;

    @Override
    int messageType() {
        return 16;
    }

    byte[] getEncodedPoint() {
        return this.encodedPoint;
    }

    ECDHClientKeyExchange(PublicKey publicKey) {
        ECPublicKey ecKey = (ECPublicKey)publicKey;
        ECPoint point = ecKey.getW();
        ECParameterSpec params = ecKey.getParams();
        this.encodedPoint = JsseJce.encodePoint(point, params.getCurve());
    }

    ECDHClientKeyExchange(HandshakeInStream input) throws IOException {
        this.encodedPoint = input.getBytes8();
    }

    @Override
    int messageLength() {
        return this.encodedPoint.length + 1;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        s.putBytes8(this.encodedPoint);
    }

    @Override
    void print(PrintStream s) throws IOException {
        s.println("*** ECDHClientKeyExchange");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(s, "ECDH Public value", this.encodedPoint);
        }
    }
}

