/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLEngineResult;
import sun.misc.HexDumpEncoder;
import xxx.sun.security.ssl.Authenticator;
import xxx.sun.security.ssl.CipherBox;
import xxx.sun.security.ssl.Debug;
import xxx.sun.security.ssl.EngineArgs;
import xxx.sun.security.ssl.EngineOutputRecord;

final class EngineWriter {
    private LinkedList<Object> outboundList = new LinkedList();
    private boolean outboundClosed = false;
    private static final Debug debug = Debug.getInstance("ssl");

    EngineWriter() {
    }

    private SSLEngineResult.HandshakeStatus getOutboundData(ByteBuffer dstBB) {
        Object msg = this.outboundList.removeFirst();
        assert (msg instanceof ByteBuffer);
        ByteBuffer bbIn = (ByteBuffer)msg;
        assert (dstBB.remaining() >= bbIn.remaining());
        dstBB.put(bbIn);
        if (this.hasOutboundDataInternal()) {
            msg = this.outboundList.getFirst();
            if (msg == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.outboundList.removeFirst();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return null;
    }

    synchronized void writeRecord(EngineOutputRecord outputRecord, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("writer side was already closed.");
        }
        outputRecord.write(authenticator, writeCipher);
        if (outputRecord.isFinishedMsg()) {
            this.outboundList.addLast((Object)SSLEngineResult.HandshakeStatus.FINISHED);
        }
    }

    private void dumpPacket(EngineArgs ea, boolean hsData) {
        try {
            HexDumpEncoder hd = new HexDumpEncoder();
            ByteBuffer bb = ea.netData.duplicate();
            int pos = bb.position();
            bb.position(pos - ea.deltaNet());
            bb.limit(pos);
            System.out.println("[Raw write" + (hsData ? "" : " (bb)") + "]: length = " + bb.remaining());
            hd.encodeBuffer(bb, (OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized SSLEngineResult.HandshakeStatus writeRecord(EngineOutputRecord outputRecord, EngineArgs ea, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        if (this.hasOutboundDataInternal()) {
            SSLEngineResult.HandshakeStatus hss = this.getOutboundData(ea.netData);
            if (debug != null && Debug.isOn("packet")) {
                this.dumpPacket(ea, true);
            }
            return hss;
        }
        if (this.outboundClosed) {
            throw new IOException("The write side was already closed");
        }
        outputRecord.write(ea, authenticator, writeCipher);
        if (debug != null && Debug.isOn("packet")) {
            this.dumpPacket(ea, false);
        }
        return null;
    }

    void putOutboundData(ByteBuffer bytes) {
        this.outboundList.addLast(bytes);
    }

    synchronized void putOutboundDataSync(ByteBuffer bytes) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("Write side already closed");
        }
        this.outboundList.addLast(bytes);
    }

    private boolean hasOutboundDataInternal() {
        return this.outboundList.size() != 0;
    }

    synchronized boolean hasOutboundData() {
        return this.hasOutboundDataInternal();
    }

    synchronized boolean isOutboundDone() {
        return this.outboundClosed && !this.hasOutboundDataInternal();
    }

    synchronized void closeOutbound() {
        this.outboundClosed = true;
    }
}

