/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import xxx.sun.security.ssl.CipherSuiteList;
import xxx.sun.security.ssl.ProtocolList;
import xxx.sun.security.ssl.SSLContextImpl;
import xxx.sun.security.ssl.SSLSocketImpl;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private String identificationProtocol = null;
    private AlgorithmConstraints algorithmConstraints = null;
    Collection<SNIMatcher> sniMatchers = Collections.emptyList();
    private boolean preferLocalCipherSuites = false;

    SSLServerSocketImpl(int port, int backlog, SSLContextImpl context) throws IOException, SSLException {
        super(port, backlog);
        this.initServer(context);
    }

    SSLServerSocketImpl(int port, int backlog, InetAddress address, SSLContextImpl context) throws IOException {
        super(port, backlog, address);
        this.initServer(context);
    }

    SSLServerSocketImpl(SSLContextImpl context) throws IOException {
        this.initServer(context);
    }

    private void initServer(SSLContextImpl context) throws SSLException {
        if (context == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = context;
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(true);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(true);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public void setWantClientAuth(boolean flag) {
        this.doClientAuth = flag ? (byte)1 : 0;
    }

    @Override
    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public void setUseClientMode(boolean flag) {
        if (this.useServerMode != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
            this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
        }
        this.useServerMode = !flag;
    }

    @Override
    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        SSLParameters params = super.getSSLParameters();
        params.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        params.setAlgorithmConstraints(this.algorithmConstraints);
        params.setSNIMatchers(this.sniMatchers);
        params.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        return params;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters params) {
        super.setSSLParameters(params);
        this.identificationProtocol = params.getEndpointIdentificationAlgorithm();
        this.algorithmConstraints = params.getAlgorithmConstraints();
        this.preferLocalCipherSuites = params.getUseCipherSuitesOrder();
        Collection<SNIMatcher> matchers = params.getSNIMatchers();
        if (matchers != null) {
            this.sniMatchers = params.getSNIMatchers();
        }
    }

    @Override
    public Socket accept() throws IOException {
        SSLSocketImpl s = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols, this.identificationProtocol, this.algorithmConstraints, this.sniMatchers, this.preferLocalCipherSuites);
        this.implAccept(s);
        s.doneConnect();
        return s;
    }

    @Override
    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

