/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl.krb5;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.kerberos.ServicePermission;
import javax.security.auth.login.LoginException;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.krb5.PrincipalName;
import xxx.sun.security.ssl.Krb5Proxy;

public class Krb5ProxyImpl
implements Krb5Proxy {
    @Override
    public Subject getClientSubject(AccessControlContext acc) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (AccessControlContext)acc);
    }

    @Override
    public Subject getServerSubject(AccessControlContext acc) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_SERVER, (AccessControlContext)acc);
    }

    @Override
    public Object getServiceCreds(AccessControlContext acc) throws LoginException {
        ServiceCreds serviceCreds = Krb5Util.getServiceCreds((GSSCaller)GSSCaller.CALLER_SSL_SERVER, null, (AccessControlContext)acc);
        return serviceCreds;
    }

    @Override
    public String getServerPrincipalName(Object serviceCreds) {
        return ((ServiceCreds)serviceCreds).getName();
    }

    @Override
    public String getPrincipalHostName(Principal principal) {
        if (principal == null) {
            return null;
        }
        String hostName = null;
        try {
            PrincipalName princName = new PrincipalName(principal.getName(), 3);
            String[] nameParts = princName.getNameStrings();
            if (nameParts.length >= 2) {
                hostName = nameParts[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    @Override
    public Permission getServicePermission(String principalName, String action) {
        return new ServicePermission(principalName, action);
    }

    @Override
    public boolean isRelated(Subject subject, Principal princ) {
        if (princ == null) {
            return false;
        }
        Set<Principal> principals = subject.getPrincipals(Principal.class);
        if (principals.contains(princ)) {
            return true;
        }
        for (KeyTab pc : subject.getPrivateCredentials(KeyTab.class)) {
            if (pc.isBound()) continue;
            return true;
        }
        return false;
    }
}

