/*
 * Decompiled with CFR 0.152.
 */
package svarzee.gps.gpsoauth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

class CipherUtil {
    CipherUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createSignature(String username, String password, BigInteger modulus, BigInteger exponent) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            bytes.write(0);
            bytes.write(Arrays.copyOfRange(this.sha1(this.createKeyStruct(modulus, exponent)), 0, 4));
            bytes.write(this.pkcs1AoepEncode(String.format("%s\u0000%s", username, password).getBytes(), this.createKey(modulus, exponent)));
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] pkcs1AoepEncode(byte[] bytes, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    private PublicKey createKey(BigInteger modulus, BigInteger exponent) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            return factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] sha1(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA1").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] createKeyStruct(BigInteger modulus, BigInteger exponent) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            bytes.write(new byte[]{0, 0, 0, -128});
            bytes.write(this.bigIntegerToBytesWithoutSign(modulus));
            bytes.write(new byte[]{0, 0, 0, 3});
            bytes.write(this.bigIntegerToBytesWithoutSign(exponent));
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] bigIntegerToBytesWithoutSign(BigInteger bigInteger) {
        byte[] bytes = bigInteger.toByteArray();
        return bytes[0] == 0 ? Arrays.copyOfRange(bytes, 1, bytes.length) : bytes;
    }
}

