/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import xxx.sun.security.ssl.InputRecord;
import xxx.sun.security.ssl.SSLSocketImpl;

class AppInputStream
extends InputStream {
    private static final byte[] SKIP_ARRAY = new byte[1024];
    private SSLSocketImpl c;
    InputRecord r;
    private final byte[] oneByte = new byte[1];

    AppInputStream(SSLSocketImpl conn) {
        this.r = new InputRecord();
        this.c = conn;
    }

    @Override
    public int available() throws IOException {
        if (this.c.checkEOF() || !this.r.isAppDataValid()) {
            return 0;
        }
        return this.r.available();
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.read(this.oneByte, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.c.checkEOF()) {
            return -1;
        }
        try {
            while (this.r.available() == 0) {
                this.c.readDataRecord(this.r);
                if (!this.c.checkEOF()) continue;
                return -1;
            }
            int howmany = Math.min(len, this.r.available());
            howmany = this.r.read(b, off, howmany);
            return howmany;
        }
        catch (Exception e) {
            this.c.handleException(e);
            return -1;
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        int len;
        int r;
        long skipped = 0L;
        while (n > 0L && (r = this.read(SKIP_ARRAY, 0, len = (int)Math.min(n, (long)SKIP_ARRAY.length))) > 0) {
            n -= (long)r;
            skipped += (long)r;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.c.close();
    }
}

