/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import xxx.sun.security.ssl.CipherSuite;
import xxx.sun.security.ssl.Debug;
import xxx.sun.security.ssl.HandshakeMessage;
import xxx.sun.security.ssl.Handshaker;
import xxx.sun.security.ssl.HelloExtensions;

final class HandshakeStateManager {
    private LinkedList<HandshakeState> upcomingStates = new LinkedList();
    private LinkedList<HandshakeState> alternatives = new LinkedList();
    private static final boolean debugIsOn = Handshaker.debug != null && Debug.isOn("handshake") && Debug.isOn("verbose");
    private static final HashMap<Byte, String> handshakeTypes = new HashMap(8);

    HandshakeStateManager() {
    }

    boolean isEmpty() {
        return this.upcomingStates.isEmpty();
    }

    List<Byte> check(byte handshakeType) throws SSLProtocolException {
        LinkedList<Byte> ignoredOptional = new LinkedList<Byte>();
        String exceptionMsg = "Handshake message sequence violation, " + handshakeType;
        if (debugIsOn) {
            System.out.println("check handshake state: " + HandshakeStateManager.toString(handshakeType));
        }
        if (this.upcomingStates.isEmpty()) {
            if (handshakeType != 0 && handshakeType != 1) {
                throw new SSLProtocolException("Handshake message sequence violation, " + handshakeType);
            }
            return Collections.emptyList();
        }
        if (handshakeType == 0) {
            return Collections.emptyList();
        }
        for (HandshakeState handshakeState : this.upcomingStates) {
            if (handshakeState.handshakeType == handshakeType) {
                return ignoredOptional;
            }
            if (handshakeState.isOptional) {
                ignoredOptional.add(handshakeState.handshakeType);
                continue;
            }
            for (HandshakeState alternative : this.alternatives) {
                if (alternative.handshakeType == handshakeType) {
                    return ignoredOptional;
                }
                if (alternative.isOptional) continue;
                throw new SSLProtocolException(exceptionMsg);
            }
            throw new SSLProtocolException(exceptionMsg);
        }
        throw new SSLProtocolException("Handshake message sequence violation, " + handshakeType);
    }

    void update(HandshakeMessage handshakeMessage, boolean isAbbreviated) throws SSLProtocolException {
        byte handshakeType = (byte)handshakeMessage.messageType();
        String exceptionMsg = "Handshake message sequence violation, " + handshakeType;
        if (debugIsOn) {
            System.out.println("update handshake state: " + HandshakeStateManager.toString(handshakeType));
        }
        boolean hasPresentState = false;
        switch (handshakeType) {
            case 0: {
                if (this.upcomingStates.isEmpty()) break;
                this.upcomingStates.add(HandshakeState.HS_CLIENT_HELLO);
                break;
            }
            case 1: {
                HandshakeState handshakeState;
                if (!this.upcomingStates.isEmpty() && (handshakeState = this.upcomingStates.pop()) != HandshakeState.HS_CLIENT_HELLO) {
                    throw new SSLProtocolException(exceptionMsg);
                }
                HandshakeMessage.ClientHello clientHello = (HandshakeMessage.ClientHello)handshakeMessage;
                this.upcomingStates.add(HandshakeState.HS_SERVER_HELLO);
                break;
            }
            case 2: {
                if (!this.upcomingStates.isEmpty()) {
                    HandshakeState handshakeState = this.upcomingStates.pop();
                    HandshakeState alternative = null;
                    if (!this.alternatives.isEmpty()) {
                        alternative = this.alternatives.pop();
                    }
                    if (handshakeState != HandshakeState.HS_SERVER_HELLO && alternative != HandshakeState.HS_SERVER_HELLO) {
                        throw new SSLProtocolException(exceptionMsg);
                    }
                } else {
                    throw new SSLProtocolException(exceptionMsg);
                }
                HandshakeMessage.ServerHello serverHello = (HandshakeMessage.ServerHello)handshakeMessage;
                HelloExtensions hes = serverHello.extensions;
                if (isAbbreviated) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC);
                    this.upcomingStates.add(HandshakeState.HS_SERVER_FINISHED);
                    this.upcomingStates.add(HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC);
                    this.upcomingStates.add(HandshakeState.HS_CLIENT_FINISHED);
                    break;
                }
                CipherSuite.KeyExchange keyExchange = serverHello.cipherSuite.keyExchange;
                if (keyExchange != CipherSuite.KeyExchange.K_KRB5 && keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT && keyExchange != CipherSuite.KeyExchange.K_DH_ANON && keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_CERTIFICATE);
                }
                if (keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT || keyExchange == CipherSuite.KeyExchange.K_DHE_RSA || keyExchange == CipherSuite.KeyExchange.K_DHE_DSS || keyExchange == CipherSuite.KeyExchange.K_DH_ANON || keyExchange == CipherSuite.KeyExchange.K_ECDHE_RSA || keyExchange == CipherSuite.KeyExchange.K_ECDHE_ECDSA || keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_KEY_EXCHANGE);
                }
                this.upcomingStates.add(HandshakeState.HS_CERTIFICATE_REQUEST);
                this.upcomingStates.add(HandshakeState.HS_SERVER_HELLO_DONE);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_CERTIFICATE);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_KEY_EXCHANGE);
                this.upcomingStates.add(HandshakeState.HS_CERTIFICATE_VERIFY);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_FINISHED);
                this.upcomingStates.add(HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC);
                this.upcomingStates.add(HandshakeState.HS_SERVER_FINISHED);
                break;
            }
            case 11: {
                HandshakeState handshakeState;
                while (!this.upcomingStates.isEmpty()) {
                    handshakeState = this.upcomingStates.pop();
                    if (handshakeState.handshakeType == handshakeType) {
                        HandshakeState nextState;
                        hasPresentState = true;
                        if (handshakeState != HandshakeState.HS_CLIENT_CERTIFICATE && handshakeState != HandshakeState.HS_SERVER_CERTIFICATE) {
                            throw new SSLProtocolException(exceptionMsg);
                        }
                        boolean isClientMessage = false;
                        if (!this.upcomingStates.isEmpty() && (nextState = this.upcomingStates.getFirst()) == HandshakeState.HS_CLIENT_KEY_EXCHANGE) {
                            isClientMessage = true;
                        }
                        if (!(isClientMessage ? handshakeState != HandshakeState.HS_CLIENT_CERTIFICATE : handshakeState != HandshakeState.HS_SERVER_CERTIFICATE)) break;
                        throw new SSLProtocolException(exceptionMsg);
                    }
                    if (handshakeState.isOptional) continue;
                    throw new SSLProtocolException(exceptionMsg);
                }
                if (hasPresentState) break;
                throw new SSLProtocolException(exceptionMsg);
            }
            default: {
                HandshakeState handshakeState;
                while (!this.upcomingStates.isEmpty()) {
                    handshakeState = this.upcomingStates.pop();
                    if (handshakeState.handshakeType == handshakeType) {
                        hasPresentState = true;
                        break;
                    }
                    if (handshakeState.isOptional) continue;
                    throw new SSLProtocolException(exceptionMsg);
                }
                if (hasPresentState) break;
                throw new SSLProtocolException(exceptionMsg);
            }
        }
        if (debugIsOn) {
            for (HandshakeState handshakeState : this.upcomingStates) {
                System.out.println("upcoming handshake states: " + (Object)((Object)handshakeState));
            }
            for (HandshakeState handshakeState : this.alternatives) {
                System.out.println("upcoming handshake alternative state: " + (Object)((Object)handshakeState));
            }
        }
    }

    void changeCipherSpec(boolean isInput, boolean isClient) throws SSLProtocolException {
        if (debugIsOn) {
            System.out.println("update handshake state: change_cipher_spec");
        }
        String exceptionMsg = "ChangeCipherSpec message sequence violation";
        HandshakeState expectedState = isClient && isInput || !isClient && !isInput ? HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC : HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC;
        boolean hasPresentState = false;
        while (!this.upcomingStates.isEmpty()) {
            HandshakeState handshakeState = this.upcomingStates.pop();
            if (handshakeState == expectedState) {
                hasPresentState = true;
                break;
            }
            if (handshakeState.isOptional) continue;
            throw new SSLProtocolException(exceptionMsg);
        }
        if (!hasPresentState) {
            throw new SSLProtocolException(exceptionMsg);
        }
        if (debugIsOn) {
            for (HandshakeState handshakeState : this.upcomingStates) {
                System.out.println("upcoming handshake states: " + (Object)((Object)handshakeState));
            }
            for (HandshakeState handshakeState : this.alternatives) {
                System.out.println("upcoming handshake alternative state: " + (Object)((Object)handshakeState));
            }
        }
    }

    private static String toString(byte handshakeType) {
        String s = handshakeTypes.get(handshakeType);
        if (s == null) {
            s = "unknown";
        }
        return s + "[" + handshakeType + "]";
    }

    static {
        handshakeTypes.put((byte)0, "hello_request");
        handshakeTypes.put((byte)1, "client_hello");
        handshakeTypes.put((byte)2, "server_hello");
        handshakeTypes.put((byte)11, "certificate");
        handshakeTypes.put((byte)12, "server_key_exchange");
        handshakeTypes.put((byte)14, "server_hello_done");
        handshakeTypes.put((byte)15, "certificate_verify");
        handshakeTypes.put((byte)16, "client_key_exchange");
        handshakeTypes.put((byte)20, "finished");
    }

    static enum HandshakeState {
        HS_HELLO_REQUEST("hello_request", 0),
        HS_CLIENT_HELLO("client_hello", 1),
        HS_SERVER_HELLO("server_hello", 2),
        HS_SERVER_CERTIFICATE("server certificate", 11),
        HS_SERVER_KEY_EXCHANGE("server_key_exchange", 12, true),
        HS_CERTIFICATE_REQUEST("certificate_request", 13, true),
        HS_SERVER_HELLO_DONE("server_hello_done", 14),
        HS_CLIENT_CERTIFICATE("client certificate", 11, true),
        HS_CLIENT_KEY_EXCHANGE("client_key_exchange", 16),
        HS_CERTIFICATE_VERIFY("certificate_verify", 15, true),
        HS_CLIENT_CHANGE_CIPHER_SPEC("client change_cipher_spec", -1),
        HS_CLIENT_FINISHED("client finished", 20),
        HS_SERVER_CHANGE_CIPHER_SPEC("server change_cipher_spec", -1),
        HS_SERVER_FINISHED("server finished", 20);

        final String description;
        final byte handshakeType;
        final boolean isOptional;

        private HandshakeState(String description, byte handshakeType) {
            this.description = description;
            this.handshakeType = handshakeType;
            this.isOptional = false;
        }

        private HandshakeState(String description, byte handshakeType, boolean isOptional) {
            this.description = description;
            this.handshakeType = handshakeType;
            this.isOptional = isOptional;
        }

        public String toString() {
            return this.description + "[" + this.handshakeType + "]" + (this.isOptional ? "(optional)" : "");
        }
    }
}

