/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import xxx.sun.security.ssl.HandshakeInStream;
import xxx.sun.security.ssl.HandshakeMessage;
import xxx.sun.security.ssl.HandshakeOutStream;
import xxx.sun.security.ssl.ProtocolVersion;

public class KerberosClientKeyExchange
extends HandshakeMessage {
    private static final String IMPL_CLASS = "xxx.sun.security.ssl.krb5.KerberosClientKeyExchangeImpl";
    private static final Class<?> implClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

        @Override
        public Class<?> run() {
            try {
                return Class.forName(KerberosClientKeyExchange.IMPL_CLASS, true, null);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
        }
    });
    private final KerberosClientKeyExchange impl = this.createImpl();

    private KerberosClientKeyExchange createImpl() {
        if (implClass != null && this.getClass() == KerberosClientKeyExchange.class) {
            try {
                return (KerberosClientKeyExchange)implClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    protected KerberosClientKeyExchange() {
    }

    public KerberosClientKeyExchange(String serverName, AccessControlContext acc, ProtocolVersion protocolVersion, SecureRandom rand) throws IOException {
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(serverName, acc, protocolVersion, rand);
    }

    public KerberosClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion clientVersion, SecureRandom rand, HandshakeInStream input, AccessControlContext acc, Object serverKeys) throws IOException {
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(protocolVersion, clientVersion, rand, input, acc, serverKeys);
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    public int messageLength() {
        return this.impl.messageLength();
    }

    @Override
    public void send(HandshakeOutStream s) throws IOException {
        this.impl.send(s);
    }

    @Override
    public void print(PrintStream p) throws IOException {
        this.impl.print(p);
    }

    public void init(String serverName, AccessControlContext acc, ProtocolVersion protocolVersion, SecureRandom rand) throws IOException {
        if (this.impl != null) {
            this.impl.init(serverName, acc, protocolVersion, rand);
        }
    }

    public void init(ProtocolVersion protocolVersion, ProtocolVersion clientVersion, SecureRandom rand, HandshakeInStream input, AccessControlContext acc, Object ServiceCreds2) throws IOException {
        if (this.impl != null) {
            this.impl.init(protocolVersion, clientVersion, rand, input, acc, ServiceCreds2);
        }
    }

    public byte[] getUnencryptedPreMasterSecret() {
        return this.impl.getUnencryptedPreMasterSecret();
    }

    public Principal getPeerPrincipal() {
        return this.impl.getPeerPrincipal();
    }

    public Principal getLocalPrincipal() {
        return this.impl.getLocalPrincipal();
    }
}

