/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.security.CryptoPrimitive;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import xxx.sun.security.ssl.SSLAlgorithmConstraints;
import xxx.sun.security.ssl.SunJSSE;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    static final int LIMIT_MAX_VALUE = 65535;
    static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion NONE;
    static final ProtocolVersion SSL20Hello;
    static final ProtocolVersion SSL30;
    static final ProtocolVersion TLS10;
    static final ProtocolVersion TLS11;
    static final ProtocolVersion TLS12;
    private static final boolean FIPS;
    static final ProtocolVersion MIN;
    static final ProtocolVersion MAX;
    static final ProtocolVersion DEFAULT;
    static final ProtocolVersion DEFAULT_HELLO;
    static final Set<ProtocolVersion> availableProtocols;
    public final int v;
    public final byte major;
    public final byte minor;
    final String name;

    private ProtocolVersion(int v, String name) {
        this.v = v;
        this.name = name;
        this.major = (byte)(v >>> 8);
        this.minor = (byte)(v & 0xFF);
    }

    private static ProtocolVersion valueOf(int v) {
        if (v == ProtocolVersion.SSL30.v) {
            return SSL30;
        }
        if (v == ProtocolVersion.TLS10.v) {
            return TLS10;
        }
        if (v == ProtocolVersion.TLS11.v) {
            return TLS11;
        }
        if (v == ProtocolVersion.TLS12.v) {
            return TLS12;
        }
        if (v == ProtocolVersion.SSL20Hello.v) {
            return SSL20Hello;
        }
        int major = v >>> 8 & 0xFF;
        int minor = v & 0xFF;
        return new ProtocolVersion(v, "Unknown-" + major + "." + minor);
    }

    public static ProtocolVersion valueOf(int major, int minor) {
        return ProtocolVersion.valueOf((major & 0xFF) << 8 | minor & 0xFF);
    }

    static ProtocolVersion valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Protocol cannot be null");
        }
        if (FIPS && (name.equals(ProtocolVersion.SSL30.name) || name.equals(ProtocolVersion.SSL20Hello.name))) {
            throw new IllegalArgumentException("Only TLS 1.0 or later allowed in FIPS mode");
        }
        if (name.equals(ProtocolVersion.SSL30.name)) {
            return SSL30;
        }
        if (name.equals(ProtocolVersion.TLS10.name)) {
            return TLS10;
        }
        if (name.equals(ProtocolVersion.TLS11.name)) {
            return TLS11;
        }
        if (name.equals(ProtocolVersion.TLS12.name)) {
            return TLS12;
        }
        if (name.equals(ProtocolVersion.SSL20Hello.name)) {
            return SSL20Hello;
        }
        throw new IllegalArgumentException(name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ProtocolVersion protocolVersion) {
        return this.v - protocolVersion.v;
    }

    static {
        ProtocolVersion[] pvs;
        NONE = new ProtocolVersion(-1, "NONE");
        SSL20Hello = new ProtocolVersion(2, "SSLv2Hello");
        SSL30 = new ProtocolVersion(768, "SSLv3");
        TLS10 = new ProtocolVersion(769, "TLSv1");
        TLS11 = new ProtocolVersion(770, "TLSv1.1");
        TLS12 = new ProtocolVersion(771, "TLSv1.2");
        FIPS = SunJSSE.isFIPS();
        MIN = FIPS ? TLS10 : SSL30;
        MAX = TLS12;
        DEFAULT = TLS12;
        DEFAULT_HELLO = FIPS ? TLS10 : SSL30;
        HashSet<ProtocolVersion> protocols = new HashSet<ProtocolVersion>(5);
        for (ProtocolVersion p : pvs = new ProtocolVersion[]{SSL20Hello, SSL30, TLS10, TLS11, TLS12}) {
            if (!SSLAlgorithmConstraints.DEFAULT_SSL_ONLY.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), p.name, null)) continue;
            protocols.add(p);
        }
        availableProtocols = Collections.unmodifiableSet(protocols);
    }
}

