/*
 * Decompiled with CFR 0.152.
 */
package xxx.sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLProtocolException;
import xxx.sun.security.ssl.ExtensionType;
import xxx.sun.security.ssl.HandshakeInStream;
import xxx.sun.security.ssl.HandshakeOutStream;
import xxx.sun.security.ssl.HelloExtension;
import xxx.sun.security.ssl.SignatureAndHashAlgorithm;

final class SignatureAlgorithmsExtension
extends HelloExtension {
    private Collection<SignatureAndHashAlgorithm> algorithms;
    private int algorithmsLen;

    SignatureAlgorithmsExtension(Collection<SignatureAndHashAlgorithm> signAlgs) {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>(signAlgs);
        this.algorithmsLen = SignatureAndHashAlgorithm.sizeInRecord() * this.algorithms.size();
    }

    SignatureAlgorithmsExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        int remains;
        this.algorithmsLen = s.getInt16();
        if (this.algorithmsLen == 0 || this.algorithmsLen + 2 != len) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
        int sequence = 0;
        for (remains = this.algorithmsLen; remains > 1; remains -= 2) {
            int hash = s.getInt8();
            int signature = s.getInt8();
            SignatureAndHashAlgorithm algorithm = SignatureAndHashAlgorithm.valueOf(hash, signature, ++sequence);
            this.algorithms.add(algorithm);
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
        return this.algorithms;
    }

    @Override
    int length() {
        return 6 + this.algorithmsLen;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        s.putInt16(this.type.id);
        s.putInt16(this.algorithmsLen + 2);
        s.putInt16(this.algorithmsLen);
        for (SignatureAndHashAlgorithm algorithm : this.algorithms) {
            s.putInt8(algorithm.getHashValue());
            s.putInt8(algorithm.getSignatureValue());
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean opened = false;
        for (SignatureAndHashAlgorithm signAlg : this.algorithms) {
            if (opened) {
                buffer.append(", " + signAlg.getAlgorithmName());
                continue;
            }
            buffer.append(signAlg.getAlgorithmName());
            opened = true;
        }
        return "Extension " + this.type + ", signature_algorithms: " + buffer;
    }
}

