/*
 * Decompiled with CFR 0.152.
 */
package io.github.tcq1007.valid.errorcode;

import com.google.auto.service.AutoService;
import com.sun.source.util.Trees;
import io.github.tcq1007.valid.errorcode.ValidErrorCode;
import io.github.tcq1007.valid.errorcode.util.EnumFieldFinder;
import io.github.tcq1007.valid.errorcode.util.ErrorCodeExtractor;
import io.github.tcq1007.valid.errorcode.util.ErrorCodeValidator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"io.github.tcq1007.valid.errorcode.ValidErrorCode"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@AutoService(value={Processor.class})
public class ErrorCodeProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Types typeUtils;
    private Trees trees;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        System.out.println("Initializing ErrorCodeProcessor");
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.trees = Trees.instance(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("Processing ErrorCodeProcessor annotations");
        for (Element element : roundEnv.getElementsAnnotatedWith(ValidErrorCode.class)) {
            this.processAnnotatedEnum(element);
        }
        return true;
    }

    private void processAnnotatedEnum(Element element) {
        if (!this.isValidEnumElement(element)) {
            return;
        }
        ValidErrorCode annotation = element.getAnnotation(ValidErrorCode.class);
        ErrorCodeValidationConfig config = this.createValidationConfig(annotation);
        this.validateAllEnumConstants(element, config);
    }

    private boolean isValidEnumElement(Element element) {
        if (element.getKind() != ElementKind.ENUM) {
            ErrorCodeValidator.reportError(element, "Only enum classes can use @ValidErrorCode annotation", this.messager);
            return false;
        }
        return true;
    }

    private ErrorCodeValidationConfig createValidationConfig(ValidErrorCode annotation) {
        return new ErrorCodeValidationConfig(annotation.prefix(), annotation.length(), annotation.codeField(), annotation.excludeValues());
    }

    private void validateAllEnumConstants(Element enumElement, ErrorCodeValidationConfig config) {
        for (Element element : enumElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.validateSingleEnumConstant(element, config);
        }
    }

    private void validateSingleEnumConstant(Element enumConstant, ErrorCodeValidationConfig config) {
        VariableElement codeField = this.findAndValidateCodeField(enumConstant, config.getCodeFieldName());
        if (codeField == null) {
            return;
        }
        Integer codeValue = this.extractErrorCodeValue(enumConstant, config.getCodeFieldName());
        if (codeValue == null) {
            this.reportErrorCodeExtractionFailure(enumConstant, config.getCodeFieldName());
            return;
        }
        if (this.shouldSkipValidation(codeValue, config.getExcludeValues())) {
            return;
        }
        this.validateErrorCodeFormat(enumConstant, codeValue, config);
    }

    private VariableElement findAndValidateCodeField(Element enumConstant, String codeFieldName) {
        VariableElement codeField = EnumFieldFinder.findErrorCodeField(enumConstant, codeFieldName);
        if (codeField == null) {
            String errorMessage = String.format("Error code field named '%s' not found", codeFieldName);
            ErrorCodeValidator.reportError(enumConstant, errorMessage, this.messager);
            return null;
        }
        if (!EnumFieldFinder.isIntegerField(codeField)) {
            String errorMessage = String.format("Error code field '%s' must be of int type", codeFieldName);
            ErrorCodeValidator.reportError(enumConstant, errorMessage, this.messager);
            return null;
        }
        return codeField;
    }

    private Integer extractErrorCodeValue(Element enumConstant, String codeFieldName) {
        return ErrorCodeExtractor.extractErrorCodeValue(enumConstant, codeFieldName, this.trees);
    }

    private void reportErrorCodeExtractionFailure(Element enumConstant, String codeFieldName) {
        String errorMessage = String.format("Unable to extract error code value from enum constant '%s', please ensure constructor parameters are integer literals", enumConstant.getSimpleName());
        ErrorCodeValidator.reportError(enumConstant, errorMessage, this.messager);
    }

    private boolean shouldSkipValidation(Integer codeValue, int[] excludeValues) {
        return ErrorCodeValidator.shouldExcludeFromValidation(codeValue, excludeValues);
    }

    private void validateErrorCodeFormat(Element enumConstant, Integer codeValue, ErrorCodeValidationConfig config) {
        ErrorCodeValidator.validateErrorCodeFormat(enumConstant, codeValue, config.getPrefix(), config.getTotalLength(), config.getCodeFieldName(), this.messager);
    }

    private static class ErrorCodeValidationConfig {
        private final String prefix;
        private final int totalLength;
        private final String codeFieldName;
        private final int[] excludeValues;

        public ErrorCodeValidationConfig(String prefix, int totalLength, String codeFieldName, int[] excludeValues) {
            this.prefix = prefix;
            this.totalLength = totalLength;
            this.codeFieldName = codeFieldName;
            this.excludeValues = excludeValues;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getTotalLength() {
            return this.totalLength;
        }

        public String getCodeFieldName() {
            return this.codeFieldName;
        }

        public int[] getExcludeValues() {
            return this.excludeValues;
        }
    }
}

