/*
 * Decompiled with CFR 0.152.
 */
package io.github.tcq1007.valid.errorcode.util;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public class EnumFieldFinder {
    public static VariableElement findErrorCodeField(Element enumConstant, String fieldName) {
        TypeElement enumClass = EnumFieldFinder.getEnumClassFromConstant(enumConstant);
        if (enumClass == null) {
            return null;
        }
        return EnumFieldFinder.findInstanceFieldByName(enumClass, fieldName);
    }

    public static boolean isIntegerField(VariableElement codeField) {
        return codeField != null && codeField.asType().getKind() == TypeKind.INT;
    }

    public static int findFieldIndexInConstructor(Element enumConstant, String fieldName) {
        try {
            TypeElement enumClass = EnumFieldFinder.getEnumClassFromConstant(enumConstant);
            if (enumClass == null) {
                return -1;
            }
            ExecutableElement constructor = EnumFieldFinder.findEnumConstructor(enumClass);
            if (constructor == null) {
                return -1;
            }
            return EnumFieldFinder.findParameterIndexByName(constructor, fieldName);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static TypeElement getEnumClassFromConstant(Element enumConstant) {
        TypeElement enumClass = (TypeElement)enumConstant.getEnclosingElement();
        if (enumClass == null || !enumClass.getKind().isClass()) {
            return null;
        }
        return enumClass;
    }

    private static VariableElement findInstanceFieldByName(TypeElement enumClass, String fieldName) {
        for (Element element : enumClass.getEnclosedElements()) {
            VariableElement field;
            if (element.getKind() != ElementKind.FIELD || !(field = (VariableElement)element).getSimpleName().contentEquals(fieldName) || field.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return field;
        }
        return null;
    }

    private static ExecutableElement findEnumConstructor(TypeElement enumClass) {
        for (Element element : enumClass.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            return (ExecutableElement)element;
        }
        return null;
    }

    private static int findParameterIndexByName(ExecutableElement constructor, String parameterName) {
        for (int i = 0; i < constructor.getParameters().size(); ++i) {
            if (!constructor.getParameters().get(i).getSimpleName().contentEquals(parameterName)) continue;
            return i;
        }
        return -1;
    }

    private EnumFieldFinder() {
    }
}

