/*
 * Decompiled with CFR 0.152.
 */
package io.github.tcq1007.valid.errorcode.util;

import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class ErrorCodeValidator {
    public static void validateErrorCodeFormat(Element element, int code, String prefix, int totalLength, String fieldName, Messager messager) {
        String codeStr = String.valueOf(code);
        ErrorCodeValidator.validateCodeLength(element, codeStr, totalLength, fieldName, messager);
        ErrorCodeValidator.validateCodePrefix(element, codeStr, prefix, fieldName, code, messager);
    }

    public static boolean shouldExcludeFromValidation(Integer value, int[] excludeValues) {
        if (value == null || excludeValues == null) {
            return false;
        }
        for (int excludeValue : excludeValues) {
            if (value != excludeValue) continue;
            return true;
        }
        return false;
    }

    private static void validateCodeLength(Element element, String codeStr, int expectedLength, String fieldName, Messager messager) {
        if (codeStr.length() != expectedLength) {
            String errorMessage = String.format("Error code field '%s' length should be %d digits, actual is %d digits (value: %s)", fieldName, expectedLength, codeStr.length(), codeStr);
            messager.printMessage(Diagnostic.Kind.ERROR, errorMessage, element);
        }
    }

    private static void validateCodePrefix(Element element, String codeStr, String expectedPrefix, String fieldName, int code, Messager messager) {
        if (!codeStr.startsWith(expectedPrefix)) {
            String errorMessage = String.format("Error code field '%s' must start with %s, actual is %s (value: %d)", fieldName, expectedPrefix, codeStr, code);
            messager.printMessage(Diagnostic.Kind.ERROR, errorMessage, element);
        }
    }

    public static void reportError(Element element, String message, Messager messager) {
        messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private ErrorCodeValidator() {
    }
}

