/*
 * Decompiled with CFR 0.152.
 */
package com.freestyle.tasks.taskqueue;

import com.freestyle.tasks.taskqueue.AbstractTask;
import com.freestyle.tasks.taskqueue.interfaces.TaskQueue;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import redis.clients.jedis.Jedis;

public class RedisTaskQueue<T extends AbstractTask>
implements TaskQueue<T>,
AutoCloseable {
    private Jedis jedis;
    private final int capacity;
    private final String taskName;
    private Function<T, String> serializer;
    private Function<String, T> deSerializer;
    private static final ConcurrentHashMap<String, Semaphore> semaphore = new ConcurrentHashMap();

    private Semaphore getSemaphore() {
        if (semaphore.containsKey(this.taskName)) {
            return semaphore.get(this.taskName);
        }
        Semaphore inst = new Semaphore(this.capacity);
        semaphore.put(this.taskName, inst);
        Long cc = this.jedis.llen(this.taskName);
        if (cc != null && cc > 0L) {
            try {
                inst.acquire(cc.intValue());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return inst;
    }

    public RedisTaskQueue(String host, int port, String password, String taskName, int capacity) {
        this.jedis = new Jedis(host, port);
        this.jedis.auth(password);
        this.jedis.connect();
        this.taskName = taskName;
        this.capacity = capacity;
    }

    @Override
    public boolean offer(T task, long ... milliSecondsToWait) {
        boolean flag;
        Semaphore lock = this.getSemaphore();
        if (milliSecondsToWait.length == 0) {
            flag = lock.tryAcquire();
        } else {
            try {
                flag = lock.tryAcquire(milliSecondsToWait[0], TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                flag = false;
            }
        }
        if (!flag) {
            return false;
        }
        String value = this.serializer.apply(task);
        this.jedis.rpush(this.taskName, new String[]{value});
        return true;
    }

    @Override
    public <T> T poll(long milliSecondsToWait) {
        T ret;
        int s = (int)(milliSecondsToWait / 1000L);
        List list = this.jedis.blpop(s <= 0 ? 1 : s, this.taskName);
        T t = ret = list == null || list.size() == 0 ? null : (T)this.deSerializer.apply((String)list.get(1));
        if (ret != null) {
            this.getSemaphore().release();
        }
        return ret;
    }

    @Override
    public int count() {
        return this.capacity - this.getSemaphore().availablePermits();
    }

    @Override
    public long queueCount() {
        return this.jedis.llen(this.taskName);
    }

    @Override
    public int remainingCapacity() {
        return this.getSemaphore().availablePermits();
    }

    @Override
    public TaskQueue<T> setConverter(Function<T, String> serializer, Function<String, T> deSerializer) {
        this.serializer = serializer;
        this.deSerializer = deSerializer;
        return this;
    }

    @Override
    public void clear() {
        this.jedis.del(this.taskName);
    }

    @Override
    public void close() {
        this.jedis.close();
    }
}

