/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

public final class NumberUtil {
    private NumberUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static boolean isNumberInRange(int number, int min, int max) {
        return number >= min && number <= max;
    }

    public static String intToString(int number, int digitsAmount) {
        String numberStr = String.valueOf(number);
        if (number < 0) {
            numberStr = NumberUtil.removeMinusBeforeNumberStr(numberStr);
        }
        if (numberStr.length() > digitsAmount) {
            numberStr = numberStr.substring(numberStr.length() - digitsAmount);
            return NumberUtil.addMinusToNumberStrIfNegativeNumber(number, numberStr);
        }
        if (numberStr.length() < digitsAmount) {
            numberStr = NumberUtil.addZeroBeforeString(numberStr, digitsAmount - numberStr.length());
        }
        return NumberUtil.addMinusToNumberStrIfNegativeNumber(number, numberStr);
    }

    private static String addMinusToNumberStrIfNegativeNumber(int number, String numberStr) {
        if (number < 0) {
            return "-" + numberStr;
        }
        return numberStr;
    }

    private static String removeMinusBeforeNumberStr(String numberStr) {
        return numberStr.substring(1);
    }

    private static String addZeroBeforeString(String str, int zeroAmount) {
        for (int i = 0; i < zeroAmount; ++i) {
            str = "0" + str;
        }
        return str;
    }
}

