/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import io.github.tuzon.projects.core.base.ObjectBase;
import io.github.tuzon.projects.core.expections.InvalidValueException;
import io.github.tuzon.projects.core.objects.ExpectObject;
import io.github.tuzon.projects.core.utils.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public final class StringUtil
extends ObjectBase {
    public static final String REPLACE_STR = "$REPLACE_STR$";

    private StringUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static List<String> removeEmptyElementsFromList(List<String> list) {
        list.removeAll(Arrays.asList("", null));
        return list;
    }

    public static boolean isExpect(String str, List<ExpectObject> expectsList) {
        for (ExpectObject expect : expectsList) {
            if (!expect.isExpect(str)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getContainList(String str, List<String> containList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String contain : containList) {
            if (!str.contains(contain)) continue;
            result.add(contain);
        }
        return result;
    }

    public static List<String> split(String str, char ch) {
        String[] arr = str.split(String.valueOf(ch), -1);
        return ListUtil.asList(arr);
    }

    public static String replace(String str, String ... args) throws InvalidValueException {
        if (args == null) {
            throw new InvalidValueException("args for [" + str + "] cannot be null");
        }
        int count = StringUtils.countMatches((CharSequence)str, (CharSequence)REPLACE_STR);
        String[] argsArr = (String[])args.clone();
        if (argsArr.length == 0) {
            throw new InvalidValueException("Replace for [" + str + "] not contain any arguments to be replaced");
        }
        if (count != argsArr.length) {
            throw new InvalidValueException("Replace for [" + str + "] contain [" + argsArr.length + "] args and should contain [" + count + "] args");
        }
        String result = str;
        for (String arg : argsArr) {
            int index = result.indexOf(REPLACE_STR);
            result = result.substring(0, index) + arg + result.substring(index + REPLACE_STR.length());
        }
        return result;
    }

    public static String xmlToString(Element element) {
        return new XMLOutputter().outputString(element);
    }

    public static String getExceptionStacktrace(Exception e) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackElement : e.getStackTrace()) {
            sb.append(stackElement.getClassName()).append(".").append(stackElement.getMethodName()).append("(").append(stackElement.getFileName()).append(":").append(stackElement.getLineNumber()).append(")\n");
        }
        return sb.toString();
    }

    public static String removeLastChar(String str) {
        if (str.length() <= 1) {
            return "";
        }
        return str.substring(0, str.length() - 1);
    }
}

