/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class DateUtil {
    public static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy hh:mm:ss";
    public static final long MS_IN_SECOND = 1000L;
    public static final long MS_IN_MINUTE = 60000L;
    public static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_DAY = 86400000L;

    private DateUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDate(DEFAULT_DATE_FORMAT);
    }

    public static String getCurrentDate(String dateFormat) {
        LocalDateTime current = LocalDateTime.now();
        return current.format(DateTimeFormatter.ofPattern(dateFormat));
    }

    public String getCurrentDateForFile() {
        String date = DateUtil.getCurrentDate();
        date = date.replaceAll("/", "_");
        date = date.replaceAll(":", "_");
        date = date.replace(" ", "_");
        return date;
    }

    public static boolean isTimeout(long startTimeMillis, long timeoutMillis) {
        if (timeoutMillis == 0L) {
            return false;
        }
        return System.currentTimeMillis() - startTimeMillis > timeoutMillis;
    }

    public static Date getDateBeforeXDays(int days) {
        long ms = System.currentTimeMillis() - (long)days * 86400000L;
        return new Date(ms);
    }
}

