/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import io.github.tuzon.projects.core.base.ObjectBase;
import io.github.tuzon.projects.core.expections.InvalidValueException;

public final class Ip4Util
extends ObjectBase {
    private Ip4Util() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static boolean isValidIp(String str) throws InvalidValueException {
        Ip4Util.validateNotNull(str);
        String[] splitStr = str.split("\\.");
        if (splitStr.length != 4) {
            return false;
        }
        for (String temp : splitStr) {
            try {
                Integer octat = Integer.valueOf(temp);
                if (Ip4Util.isNumberBetween0To255(octat)) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static String toIPv4(int[] octats) throws InvalidValueException {
        Ip4Util.validateNotNull(octats);
        if (octats.length != 4) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (Ip4Util.isNumberBetween0To255(octats[i])) continue;
            return null;
        }
        return String.valueOf(octats[0]) + "." + String.valueOf(octats[1]) + "." + String.valueOf(octats[2]) + "." + String.valueOf(octats[3]);
    }

    private static boolean isNumberBetween0To255(Integer num) {
        return num >= 0 && num <= 255;
    }
}

