/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.tests.asserts;

import org.apache.log4j.Logger;
import org.testng.Assert;

public class SoftAssert {
    private static final Logger logger = Logger.getLogger((String)SoftAssert.class.getName());
    private static String errors = "";
    private static InfoMessageLogLevelEnum infoMessageLevel = InfoMessageLogLevelEnum.INFO;

    public static void assertTrueNow(boolean condition, String errorMessage) {
        SoftAssert.assertTrue(condition, errorMessage);
        SoftAssert.assertAll();
    }

    public static void assertTrueNow(boolean condition, String errorMessage, String infoMessage) {
        SoftAssert.assertTrue(condition, errorMessage, infoMessage);
        SoftAssert.assertAll();
    }

    public static void assertNotNullNow(Object object, String errorMessage) {
        SoftAssert.assertNotNullNow(object, errorMessage, null);
    }

    public static void assertNotNullNow(Object object, String errorMessage, String infoMessage) {
        SoftAssert.assertNotNull(object, errorMessage, infoMessage);
        SoftAssert.assertAll();
    }

    public static void failNow(String errorMessage) {
        SoftAssert.assertTrueNow(false, errorMessage);
    }

    public static boolean assertNotNull(Object object, String errorMessage) {
        return SoftAssert.assertNotNull(object, errorMessage, null);
    }

    public static boolean assertNotNull(Object object, String errorMessage, String infoMessage) {
        return SoftAssert.assertTrue(object != null, errorMessage, infoMessage);
    }

    public static boolean assertTrue(boolean condition, String errorMessage) {
        return SoftAssert.assertTrue(condition, errorMessage, null);
    }

    public static boolean assertTrue(boolean condition, String errorMessage, String infoMessage) {
        if (infoMessage != null) {
            SoftAssert.printInfoMessage(infoMessage);
        }
        if (!condition) {
            errorMessage = "[Assertion Error] " + errorMessage;
            logger.error((Object)errorMessage);
            if (!errors.isEmpty()) {
                errors = errors + "\n";
            }
            errors = errors + errorMessage;
        }
        return condition;
    }

    public static void fail(String errorMessage) {
        SoftAssert.assertTrue(false, errorMessage);
    }

    public static void assertAll() {
        String temp = errors;
        errors = "";
        Assert.assertTrue((boolean)temp.isEmpty(), (String)temp);
    }

    public static String getCurrentErrors() {
        return errors;
    }

    public static String emptyErrors() {
        String temp = errors;
        errors = "";
        return temp;
    }

    public static void setInfoMessageLogLevel(InfoMessageLogLevelEnum level) {
        infoMessageLevel = level;
    }

    private static void printInfoMessage(String message) {
        if (infoMessageLevel == InfoMessageLogLevelEnum.TRACE) {
            logger.trace((Object)message);
        } else if (infoMessageLevel == InfoMessageLogLevelEnum.DEBUG) {
            logger.debug((Object)message);
        } else if (infoMessageLevel == InfoMessageLogLevelEnum.INFO) {
            logger.info((Object)message);
        }
    }

    public static enum InfoMessageLogLevelEnum {
        TRACE,
        DEBUG,
        INFO;

    }
}

