/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.tests.base;

import io.github.tuzon.projects.core.tests.asserts.SoftAssert;
import io.github.tuzon.projects.core.tests.exceptions.InvalidTestException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class BaseTest {
    public static final String CLASS_SEPARETOR = "================================================================";
    private final Logger logger = Logger.getLogger((String)BaseTest.class.getName());

    protected BaseTest() {
    }

    @BeforeClass
    public void beforeClassBaseTest() {
        this.logger.info((Object)("\n================================================================\nStarting Class [" + super.getClass().getSimpleName() + "]\n" + CLASS_SEPARETOR));
    }

    @BeforeMethod
    public void beforeMethodBaseTest(Method method) {
        this.logger.info((Object)("Starting Test [" + super.getClass().getSimpleName() + "." + method.getName() + "]"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AfterMethod
    public void afterMethodBaseTest(ITestResult result) throws InvalidTestException {
        String errors = SoftAssert.emptyErrors();
        if (result.isSuccess()) {
            if (!errors.isEmpty()) throw new InvalidTestException(this.getInvalidTestExceptionMessage(result, errors));
            this.logger.info((Object)("Test [" + super.getClass().getSimpleName() + "." + result.getName() + "] PASSED"));
            return;
        } else {
            this.logger.info((Object)("Test [" + super.getClass().getSimpleName() + "." + result.getTestName() + "] FAILED"));
            if (SoftAssert.emptyErrors().isEmpty()) return;
            throw new InvalidTestException(this.getInvalidTestExceptionMessage(result, errors));
        }
    }

    private String getInvalidTestExceptionMessage(ITestResult result, String errors) {
        return "Missing SoftAssert.assertAll() in test [" + super.getClass().getSimpleName() + "." + result.getName() + "]\nAssert error list:\n" + errors;
    }
}

