/*
 * Decompiled with CFR 0.152.
 */
package org.javagrader;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.javagrader.CustomGradingResult;
import org.javagrader.Grade;
import org.javagrader.GradeFeedback;
import org.javagrader.PrintConstants;
import org.javagrader.TestResultStatus;

public class TestMethodResult {
    private String methodDisplayName;
    private TestResultStatus status;
    private Method testMethod;
    private CustomGradingResult customGradingResult;

    public TestMethodResult(String methodDisplayName, Method testMethod, TestResultStatus status, CustomGradingResult customGradingResult) {
        this.methodDisplayName = methodDisplayName;
        this.testMethod = testMethod;
        this.status = status;
        this.customGradingResult = customGradingResult;
    }

    public TestMethodResult(String methodDisplayName, Method testMethod, TestResultStatus status) {
        this(methodDisplayName, testMethod, status, null);
    }

    public TestResultStatus status() {
        return this.status;
    }

    public boolean isGraded() {
        return this.testMethod.isAnnotationPresent(Grade.class);
    }

    public boolean isAborted() {
        return this.status == TestResultStatus.ABORTED;
    }

    public boolean isDisabled() {
        return this.status == TestResultStatus.DISABLED;
    }

    public double maxGrade() {
        if (this.isGraded()) {
            Grade g = this.testMethod.getAnnotation(Grade.class);
            return g.value();
        }
        return 1.0;
    }

    private String comment() {
        if (this.customGradingResult != null) {
            return "\"" + this.customGradingResult.feedback + "\"";
        }
        GradeFeedback[] feedbacks = (GradeFeedback[])this.testMethod.getAnnotationsByType(GradeFeedback.class);
        if (feedbacks != null) {
            String msg = Arrays.stream(feedbacks).filter(f -> f.on() == this.status).findFirst().map(GradeFeedback::message).orElse("");
            if (msg.length() > 1) {
                return "\"" + msg + "\"";
            }
            return msg;
        }
        return "";
    }

    public double grade() {
        if (this.customGradingResult != null) {
            if (this.customGradingResult.explicitGrade) {
                return this.customGradingResult.grade;
            }
            return this.customGradingResult.status == TestResultStatus.SUCCESS ? this.maxGrade() : 0.0;
        }
        return this.status == TestResultStatus.SUCCESS ? this.maxGrade() : 0.0;
    }

    public String format(PrintConstants.PrintMode mode, double classGrade, double sumGradesInTestClass) {
        String sep = PrintConstants.separator(mode, PrintConstants.SeparatorsType.CONTENT);
        return String.format("%s%s%s%s%s%s%s%s%s", PrintConstants.globalPrefix(mode), PrintConstants.separator(mode, PrintConstants.SeparatorsType.METHOD_PREFIX), this.methodDisplayName, PrintConstants.separator(mode, PrintConstants.SeparatorsType.METHOD_SUFFIX), sep, PrintConstants.statusToIcon(this.status), sep, PrintConstants.formatGrade(this.scaleTestGrade(classGrade, sumGradesInTestClass), this.scaleMaxGrade(classGrade, sumGradesInTestClass)), this.commentIfPresent(mode));
    }

    private double scaleTestGrade(double classGrade, double sumGradesInTestClass) {
        return this.grade() / sumGradesInTestClass * classGrade;
    }

    private double scaleMaxGrade(double classGrade, double sumGradesInTestClass) {
        return this.maxGrade() / sumGradesInTestClass * classGrade;
    }

    private String commentIfPresent(PrintConstants.PrintMode mode) {
        String comment = this.comment();
        if (comment != null && !comment.equals("")) {
            return String.format("%s%s", PrintConstants.separator(mode, PrintConstants.SeparatorsType.COMMENT), comment);
        }
        return "";
    }
}

