/*
 * Decompiled with CFR 0.152.
 */
package org.javagrader;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.javagrader.TestResultStatus;

public final class PrintConstants {
    public static final String RSTBold = "**";
    private static final DecimalFormat df = PrintConstants.initDF();
    public static final String RSTTableHeader = ".. csv-table::\n    :header: \"Test\", \"Status\", \"Grade\", \"Comment\"\n    :widths: auto\n    ";

    public static String separator(PrintMode mode, SeparatorsType sep) {
        switch (mode) {
            case NONE: {
                return "";
            }
            case NORMAL: {
                switch (sep) {
                    case CLASS_PREFIX: {
                        return "- ";
                    }
                    case METHOD_PREFIX: {
                        return "\t";
                    }
                    case CONTENT: {
                        return " ";
                    }
                    case COMMENT: {
                        return "\n\t\t";
                    }
                    case CLASS_SUFFIX: 
                    case METHOD_SUFFIX: {
                        return "";
                    }
                }
                break;
            }
            case RST: {
                switch (sep) {
                    case CLASS_PREFIX: {
                        return "\"**";
                    }
                    case CLASS_SUFFIX: {
                        return "**\"";
                    }
                    case METHOD_PREFIX: {
                        return "\"**\u2192** ";
                    }
                    case METHOD_SUFFIX: {
                        return "\"";
                    }
                    case CONTENT: 
                    case COMMENT: {
                        return ",";
                    }
                }
            }
        }
        return null;
    }

    private static DecimalFormat initDF() {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.getGroupingSeparator();
        return new DecimalFormat("0.##", otherSymbols);
    }

    public static String format(double d) {
        return df.format(d);
    }

    public static String statusToIcon(TestResultStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case TestResultStatus.DISABLED -> "\ud83d\udeab Disabled";
            case TestResultStatus.FAIL -> "\u274c **Failed**";
            case TestResultStatus.SUCCESS -> "\u2705\ufe0f Success";
            case TestResultStatus.ABORTED -> "\ud83d\udeab Aborted";
            case TestResultStatus.TIMEOUT -> "\ud83d\udd51 **Timeout**";
        };
    }

    public static String formatGrade(double grade, double maxGrade) {
        return String.format("%s/%s", PrintConstants.format(grade), PrintConstants.format(maxGrade));
    }

    public static String globalPrefix(PrintMode mode) {
        if (mode == PrintMode.RST) {
            return "    ";
        }
        return "";
    }

    public static enum PrintMode {
        NONE,
        RST,
        NORMAL;

    }

    public static enum SeparatorsType {
        CLASS_PREFIX,
        CLASS_SUFFIX,
        METHOD_PREFIX,
        METHOD_SUFFIX,
        CONTENT,
        COMMENT;

    }
}

