/*
 * Decompiled with CFR 0.152.
 */
package org.javagrader;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class ConditionalOrderingExtension
implements ExecutionCondition,
TestWatcher,
BeforeTestExecutionCallback {
    private static boolean disable = false;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        boolean orderBeforeFinished;
        Class<?> annotated = this.getAnnotatedClass(extensionContext);
        boolean bl = orderBeforeFinished = (Boolean)extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).getOrDefault(annotated, Boolean.class, (Object)false) == false;
        if (orderBeforeFinished) {
            return ConditionEvaluationResult.enabled((String)"The test before succeeded");
        }
        return ConditionEvaluationResult.disabled((String)"Test ignored as the last one failed");
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        disable = true;
        Class<?> annotated = this.getAnnotatedClass(context);
        if (annotated != null) {
            context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put(annotated, (Object)true);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        Class<?> annotated = this.getAnnotatedClass(extensionContext);
    }

    private Class<?> getAnnotatedClass(ExtensionContext context) {
        ExtendWith ec;
        Class testClass = context.getRequiredTestClass();
        Optional testMethod = context.getTestMethod();
        ExtendWith em = null;
        if (testMethod.isPresent()) {
            em = ((Method)testMethod.get()).getAnnotation(ExtendWith.class);
        }
        if ((ec = testClass.getAnnotation(ExtendWith.class)) == null && em == null) {
            return this.getAnnotatedClass(testClass.getSuperclass());
        }
        return testClass;
    }

    private Class<?> getAnnotatedClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ExtendWith ec = clazz.getAnnotation(ExtendWith.class);
        if (ec == null) {
            return this.getAnnotatedClass(clazz.getSuperclass());
        }
        return clazz;
    }
}

