/*
 * Decompiled with CFR 0.152.
 */
package io.github.uinnn.database;

import io.github.uinnn.database.AbstractDatabasePrototype;
import io.github.uinnn.database.DatabaseType;
import io.github.uinnn.database.LocalDatabasePrototype;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/github/uinnn/database/AbstractLocalDatabasePrototype;", "Lio/github/uinnn/database/AbstractDatabasePrototype;", "Lio/github/uinnn/database/LocalDatabasePrototype;", "type", "Lio/github/uinnn/database/DatabaseType;", "file", "Ljava/io/File;", "(Lio/github/uinnn/database/DatabaseType;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "database-framework"})
public abstract class AbstractLocalDatabasePrototype
extends AbstractDatabasePrototype
implements LocalDatabasePrototype {
    @NotNull
    private File file;

    public AbstractLocalDatabasePrototype(@NotNull DatabaseType type, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(type);
        this.file = file;
        File file2 = this.getFile().getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        if (type == DatabaseType.SQLITE && !this.getFile().exists()) {
            this.getFile().createNewFile();
        }
    }

    @Override
    @NotNull
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.file = file;
    }
}

