/*
 * Decompiled with CFR 0.152.
 */
package io.github.uinnn.database;

import io.github.uinnn.database.DatabasePrototype;
import io.github.uinnn.database.DatabaseType;
import io.github.uinnn.database.LocalDatabasePrototype;
import io.github.uinnn.database.SerialPrototype;
import io.github.uinnn.database.ServerDatabasePrototype;
import io.github.uinnn.database.factory.PrototypeFactory;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u00a8\u0006\t"}, d2={"asLocalPrototype", "Lio/github/uinnn/database/LocalDatabasePrototype;", "Lio/github/uinnn/database/SerialPrototype;", "file", "Ljava/io/File;", "asPrototype", "Lio/github/uinnn/database/DatabasePrototype;", "asServerPrototype", "Lio/github/uinnn/database/ServerDatabasePrototype;", "database-framework"})
public final class SerialPrototypeKt {
    @NotNull
    public static final LocalDatabasePrototype asLocalPrototype(@NotNull SerialPrototype $this$asLocalPrototype, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$asLocalPrototype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = $this$asLocalPrototype.getType() == DatabaseType.SQLITE || $this$asLocalPrototype.getType() == DatabaseType.H2;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "The database type " + (Object)((Object)$this$asLocalPrototype.getType()) + " provided is not a local database prototype. Only 'SQLITE' and 'H2' is local.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DatabaseType databaseType = $this$asLocalPrototype.getType();
        n = WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()];
        return n == 1 ? PrototypeFactory.INSTANCE.createH2Prototype(file) : PrototypeFactory.INSTANCE.createSQLitePrototype(file);
    }

    @NotNull
    public static final ServerDatabasePrototype asServerPrototype(@NotNull SerialPrototype $this$asServerPrototype) {
        Intrinsics.checkNotNullParameter((Object)$this$asServerPrototype, (String)"<this>");
        boolean bl = $this$asServerPrototype.getType() == DatabaseType.MYSQL || $this$asServerPrototype.getType() == DatabaseType.POSTGRE;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "The database type " + (Object)((Object)$this$asServerPrototype.getType()) + " provided is not a server database prototype. Only 'MYSQL' and 'POSTGRE' is server.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DatabaseType databaseType = $this$asServerPrototype.getType();
        n = WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()];
        return n == 2 ? PrototypeFactory.INSTANCE.createPostgrePrototype($this$asServerPrototype) : PrototypeFactory.INSTANCE.createMySQLPrototype($this$asServerPrototype);
    }

    @NotNull
    public static final DatabasePrototype asPrototype(@NotNull SerialPrototype $this$asPrototype, @Nullable File file) {
        DatabasePrototype databasePrototype;
        Intrinsics.checkNotNullParameter((Object)$this$asPrototype, (String)"<this>");
        DatabaseType databaseType = $this$asPrototype.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()];
        switch (n) {
            case 3: {
                boolean bl = false;
                boolean bl2 = false;
                if (file == null) {
                    boolean bl3 = false;
                    String string = "The database type " + (Object)((Object)$this$asPrototype.getType()) + " is local, but no file is specified.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                databasePrototype = PrototypeFactory.INSTANCE.createSQLitePrototype(file);
                break;
            }
            case 1: {
                boolean bl = false;
                boolean bl4 = false;
                if (file == null) {
                    boolean bl5 = false;
                    String string = "The database type " + (Object)((Object)$this$asPrototype.getType()) + " is local, but no file is specified.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                databasePrototype = PrototypeFactory.INSTANCE.createH2Prototype(file);
                break;
            }
            case 2: {
                databasePrototype = PrototypeFactory.INSTANCE.createPostgrePrototype($this$asPrototype);
                break;
            }
            case 4: {
                databasePrototype = PrototypeFactory.INSTANCE.createMySQLPrototype($this$asPrototype);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return databasePrototype;
    }

    public static /* synthetic */ DatabasePrototype asPrototype$default(SerialPrototype serialPrototype, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        return SerialPrototypeKt.asPrototype(serialPrototype, file);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            nArray[DatabaseType.H2.ordinal()] = 1;
            nArray[DatabaseType.POSTGRE.ordinal()] = 2;
            nArray[DatabaseType.SQLITE.ordinal()] = 3;
            nArray[DatabaseType.MYSQL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

