/*
 * Decompiled with CFR 0.152.
 */
package io.github.uinnn.database.columns;

import io.github.uinnn.database.columns.MarkColumnType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/github/uinnn/database/columns/MarkLimitedColumnType;", "T", "", "Lio/github/uinnn/database/columns/MarkColumnType;", "length", "", "type", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)V", "getLength", "()I", "sqlType", "", "validateValueBeforeUpdate", "", "value", "database-framework"})
public class MarkLimitedColumnType<T>
extends MarkColumnType<T> {
    private final int length;

    public MarkLimitedColumnType(int length, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type);
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    public void validateValueBeforeUpdate(@Nullable Object value) {
        if (value instanceof byte[]) {
            boolean bl = ((byte[])value).length <= this.length;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Value '" + value + "' can't be stored to database column because exceeds length (" + this.getLength() + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }
}

