/*
 * Decompiled with CFR 0.152.
 */
package io.github.uinnn.database.factory;

import io.github.uinnn.database.H2Prototype;
import io.github.uinnn.database.LocalDatabasePrototype;
import io.github.uinnn.database.MySQLPrototype;
import io.github.uinnn.database.PostgrePrototype;
import io.github.uinnn.database.SQLitePrototype;
import io.github.uinnn.database.SerialPrototype;
import io.github.uinnn.database.ServerDatabasePrototype;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ:\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ:\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"Lio/github/uinnn/database/factory/PrototypeFactory;", "", "()V", "createH2Prototype", "Lio/github/uinnn/database/LocalDatabasePrototype;", "file", "Ljava/io/File;", "createMySQLPrototype", "Lio/github/uinnn/database/ServerDatabasePrototype;", "serial", "Lio/github/uinnn/database/SerialPrototype;", "username", "", "password", "databaseName", "host", "port", "", "useSSL", "", "createPostgrePrototype", "createSQLitePrototype", "database-framework"})
public final class PrototypeFactory {
    @NotNull
    public static final PrototypeFactory INSTANCE = new PrototypeFactory();

    private PrototypeFactory() {
    }

    @NotNull
    public final LocalDatabasePrototype createSQLitePrototype(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new SQLitePrototype(file);
    }

    @NotNull
    public final LocalDatabasePrototype createH2Prototype(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new H2Prototype(file);
    }

    @NotNull
    public final ServerDatabasePrototype createMySQLPrototype(@NotNull String username, @NotNull String password, @NotNull String databaseName, @NotNull String host, int port, boolean useSSL) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new MySQLPrototype(username, password, databaseName, host, port, useSSL);
    }

    public static /* synthetic */ ServerDatabasePrototype createMySQLPrototype$default(PrototypeFactory prototypeFactory, String string, String string2, String string3, String string4, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 3306;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        return prototypeFactory.createMySQLPrototype(string, string2, string3, string4, n, bl);
    }

    @NotNull
    public final ServerDatabasePrototype createPostgrePrototype(@NotNull String username, @NotNull String password, @NotNull String databaseName, @NotNull String host, int port, boolean useSSL) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new PostgrePrototype(username, password, databaseName, host, port, useSSL);
    }

    public static /* synthetic */ ServerDatabasePrototype createPostgrePrototype$default(PrototypeFactory prototypeFactory, String string, String string2, String string3, String string4, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 3306;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        return prototypeFactory.createPostgrePrototype(string, string2, string3, string4, n, bl);
    }

    @NotNull
    public final ServerDatabasePrototype createMySQLPrototype(@NotNull SerialPrototype serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        return new MySQLPrototype(serial.getUsername(), serial.getPassword(), serial.getDatabase(), serial.getHost(), serial.getPort(), serial.getUseSSL());
    }

    @NotNull
    public final ServerDatabasePrototype createPostgrePrototype(@NotNull SerialPrototype serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        return new PostgrePrototype(serial.getUsername(), serial.getPassword(), serial.getDatabase(), serial.getHost(), serial.getPort(), serial.getUseSSL());
    }
}

