/*
 * Decompiled with CFR 0.152.
 */
package io.github.uinnn.interfaces;

import io.github.uinnn.interfaces.Engine;
import io.github.uinnn.interfaces.GraphicalInterface;
import io.github.uinnn.interfaces.GraphicalInterfaceKt;
import io.github.uinnn.interfaces.common.InventoriesKt;
import io.github.uinnn.interfaces.common.PlayersKt;
import io.github.uinnn.interfaces.interfaces.ObserverKind;
import io.github.uinnn.interfaces.interfaces.Workable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/github/uinnn/interfaces/InterfaceService;", "Lorg/bukkit/event/Listener;", "()V", "plugin", "Lorg/bukkit/plugin/Plugin;", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "setPlugin", "(Lorg/bukkit/plugin/Plugin;)V", "onClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "onDrag", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "onOpen", "Lorg/bukkit/event/inventory/InventoryOpenEvent;", "onPickup", "Lorg/bukkit/event/player/PlayerPickupItemEvent;", "startup", "interface-framework"})
public final class InterfaceService
implements Listener {
    @NotNull
    public static final InterfaceService INSTANCE = new InterfaceService();
    public static Plugin plugin;

    private InterfaceService() {
    }

    @NotNull
    public final Plugin getPlugin() {
        Plugin plugin = InterfaceService.plugin;
        if (plugin != null) {
            return plugin;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"plugin");
        throw null;
    }

    public final void setPlugin(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"<set-?>");
        InterfaceService.plugin = plugin;
    }

    public final void startup(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.setPlugin(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public final void onOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GraphicalInterface graphicalInterface = InventoriesKt.interfaceOrNull((InventoryEvent)event);
        if (graphicalInterface == null) {
            return;
        }
        GraphicalInterface graphical = graphicalInterface;
        event.setCancelled(!graphical.permits(ObserverKind.ACCESS));
    }

    @EventHandler
    public final void onDrag(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GraphicalInterface graphicalInterface = InventoriesKt.interfaceOrNull((InventoryEvent)event);
        if (graphicalInterface == null) {
            return;
        }
        GraphicalInterface graphical = graphicalInterface;
        event.setCancelled(!graphical.permits(ObserverKind.DRAG));
    }

    @EventHandler
    public final void onClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Workable workable = InventoriesKt.interfaceOrNull((InventoryEvent)event);
        if (workable == null) {
            return;
        }
        GraphicalInterface graphical = workable;
        event.setCancelled(graphical.permits(ObserverKind.PRESS_CANCELLABLE));
        if (graphical.permits(ObserverKind.PRESS) && (workable = GraphicalInterfaceKt.selectOrNull(graphical, event.getRawSlot())) != null) {
            ((Engine)workable).press(event);
        }
    }

    @EventHandler
    public final void onClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GraphicalInterface graphicalInterface = InventoriesKt.interfaceOrNull((InventoryEvent)event);
        if (graphicalInterface == null) {
            return;
        }
        GraphicalInterface graphical = graphicalInterface;
        if (graphical.permits(ObserverKind.UNCESS)) {
            graphical.uncess(false);
        } else {
            Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> InterfaceService.onClose$lambda-0(event, graphical), 1L);
        }
    }

    @EventHandler
    public final void onPickup(@NotNull PlayerPickupItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        GraphicalInterface graphicalInterface = PlayersKt.interfaceOrNull(player);
        if (graphicalInterface == null) {
            return;
        }
        GraphicalInterface graphical = graphicalInterface;
        event.setCancelled(!graphical.permits(ObserverKind.PICKUP));
    }

    private static final void onClose$lambda-0(InventoryCloseEvent $event, GraphicalInterface $graphical) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)$graphical, (String)"$graphical");
        $event.getPlayer().openInventory((Inventory)$graphical);
    }
}

